$(document).ready(function() {
	var options = { 
		beforeSubmit: showRequest,
		success: showResponse,
		dataType: 'json' 
	}; 
	$('body').delegate('#image','change', function(){
		$('#upload').ajaxForm(options).submit();  	
		$(this).val('');
	}); 

	$('#output').delegate('.img-remove','click',function(){
		$.post('/upload/remove-image',{file:$(this).attr('data')},function(response){
			reloadResponse(response);
		});
	});
});		

function showRequest(formData, jqForm, options) { 
	$('#progBar').show();
	$("#validation-errors").hide().empty();
	$("#output").css('display','none');
	return true;
} 
function showResponse(response, statusText, xhr, $form)  { 
	if(response.success == false)
	{
		var arr = response.errors;
		$.each(arr, function(index, value)
		{
			if (value.length != 0)
			{
				$("#validation-errors").append('<div class="alert alert-danger center">'+ value +'<div>');
			}
		});
		$("#validation-errors").show();
	} else {
		reloadResponse(response);
	}
	$('#progBar').hide();
}

function reloadResponse(response){
	var img = '';
	$.each(response.file, function(index, value){
		img+="<div class='col-md-6' style='padding:0px;border:solid 1px #eee'><img src='/uploads/"+value+"' style='max-height:217px;min-height:217px'/>"
		+"<button type='button' class='btn btn-xs btn-danger img-remove' data='"+value+"'>"
		+"<span class='glyphicon glyphicon-remove'><span></button></div>";
	});
	$("#output").html(img);
	$("#output").css('display','block');
}