<!DOCTYPE html>
<html lang="en">
<head prefix="og: http://ogp.me/ns#">
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <meta name="description" content="Welcome to Market Kounimap, the best virtual shopping mall in Malaysia. Free registration or simple login using your facebook account.">
  <meta name="keywords" content="kounimap, unimap, kounimap idea, shopping, online, virtual shopping, shopping mall, free, buy online, online shop, perlis, roap, roapers">
  <meta name="author" content="Kounimap Idea">
  <meta name="robots" content="index, nofollow">

  <meta property="fb:app_id" content="1430859960526136">
  @yield('meta')

  <link rel="shortcut icon" href="/img-system/icon.png">

  <title>Market Kounimap - virtual shopping mall</title>

  <!-- Bootstrap core CSS -->
  <link href="/css/bootstrap.min.css" rel="stylesheet">
  <link href="/css/custom.css" rel="stylesheet">
  <link href="/css/animate.css" rel="stylesheet">
  <link href="/font-awesome-4.1.0/css/font-awesome.min.css" rel="stylesheet">
  <link href="/summernote/dist/summernote.css" rel="stylesheet"> 
  <link href="/jquery.dataTables/css/jquery.dataTables.css" rel="stylesheet">
  <!-- Just for debugging purposes. Don't actually copy this line! -->
  <!--[if lt IE 9]><script src="../../assets/js/ie8-responsive-file-warning.js"></script><![endif]-->

  <!-- HTML5 shim and Respond.js IE8 support of HTML5 elements and media queries -->
<!--[if lt IE 9]>
<script src="https://oss.maxcdn.com/libs/html5shiv/3.7.0/html5shiv.js"></script>
<script src="https://oss.maxcdn.com/libs/respond.js/1.4.2/respond.min.js"></script>
<![endif]-->
</head>

<body>

  <div class="navbar navbar-inverse navbar-fixed-top" role="navigation">
    <div class="container">

      <!-- MOBILE TOP HEADER -->
      <div class="navbar-header visible-xs" style="padding:5px">
        <div class="row">

          <div class="col-xs-2 center">
            <button type="button" class="btn btn-default btn-xs btn-block" data-toggle="collapse" data-target="#mobileCategory">
              <span class="glyphicon glyphicon-align-justify"></span>
            </button>
          </div>

          <div class="col-xs-8 center">
            <form action="/search" method="get">
              <div class="input-group"> 
                <input class="form-control search" style="top:0px" type="text" name="search" placeholder="Search Item" required>
                <span class="input-group-btn">
                  <button type="submit" class="btn btn-xs btn-default"><span class="glyphicon glyphicon-search"></span></button>
                </span>
              </div>
            </form>
          </div>

          <div class="col-xs-2 center">
            <button type="button" class="btn btn-default btn-xs btn-block" data-toggle="collapse" data-target="#topMenu">
              <span class="glyphicon glyphicon-align-justify"></span>
            </button>
          </div>

        </div>
      </div>
      <!-- END MOBILE TOP HEADER -->

      <!-- MOBILE CATEGORY-->
      <div class="visible-xs">
        <div class="navbar-collapse collapse" id="mobileCategory">
          <ul class="nav navbar-nav navbar-right">
            <div class="alert footer center">All Categories</div>
            @foreach($category_list as $cat_list)
            <li><a href="/category/{{$cat_list->id}}/{{Str::slug($cat_list->name)}}"><span class="{{$cat_list->icon}}"></span> {{$cat_list->name}}</a></li>
            @endforeach   
          </ul>
        </div>
      </div>
      <!-- END MOBILE CATEGORY-->

      <!-- LIST MENU-->
      <div class="navbar-collapse collapse" id="topMenu">
        <ul class="nav navbar-nav navbar-right">
          @if(Auth::user())
          <li><a href="/member/profile/personal-detail">Hi, {{Auth::user()->name}}</a></li>  
          <li><a href="/logout">(Logout)</a></li>  
          <li><a href="/member/store/manage-store">My Shop</a></li>  
          @else
          <li><a href="/login">Login</a></li>  
          <li><a href="/register">Register</a></li>     
          @endif
          <li>
            <a href="/member/sell/product-list">Sell
              @if( !is_null(Auth::user()) )
              @if(Auth::user()->countSellOrderStatusTotal()!=0)
              <span class="badge">{{Auth::user()->countSellOrderStatusTotal()}} </span>
              @endif
              @endif
            </a>
          </li>
          <li>
            <a href="/member/buy/order">Buy
              @if( !is_null(Auth::user()) )
              @if(Auth::user()->countBuyOrderStatusTotal()!=0)
              <span class="badge">{{Auth::user()->countBuyOrderStatusTotal()}} </span>
              @endif
              @endif
            </a>
          </li>     
          <li>
            @if(Session::has('statusCart'))
            <div class="arrow_box animated swing">
              <span class="glyphicon glyphicon-shopping-cart"></span><span class="glyphicon glyphicon-plus"></span>
            </div>
            @endif
            <a href="/member/buy/cart">Cart 
              <span class="badge">{{(!is_null(Auth::user()))?Auth::user()->cartBil():0}}</span>
            </a>
          </li>     
          <li class="dropdown">
            <a class="dropdown-toggle" id="language" data-toggle="dropdown" href="">Eng</a>
            <ul class="dropdown-menu" role="menu" aria-labelledby="language">
              <li role="presentation"><a role="menuitem" tabindex="-1" href="#">English</a></li>
            </ul>
          </li>     
        </ul>
      </div>
      <!-- END LIST MENU -->


    </div>
  </div>

  <div class="container">

    <!-- Category Menu-->
    <div class="visible-sm visible-md visible-lg">
      <div id="sideMenuBar"><br>A<br>l<br>l<br><br>C<br>a<br>t<br>e<br>g<br>o<br>r<br>i<br>e<br>s</div>
      <div id="sideMenuItem">
        <ul class="nav nav-sidebar">
          <div class="alert footer center">All Categories</div>
          @foreach($category_list as $cat_list)
          <li><a href="/category/{{$cat_list->id}}/{{Str::slug($cat_list->name)}}"><span class="{{$cat_list->icon}}"></span> {{$cat_list->name}}</a></li>
          @endforeach
        </ul>    
      </div>
    </div>
    <!-- End Category Menu-->


    <div class="row">
      <div class="col-xs-offset-3 col-xs-6 col-sm-offset-4 col-sm-4 col-md-offset-0 col-md-3 center">
        <a href="/"><img src="/img-system/logo.png" alt="market kounimap"></a>
      </div>
      @foreach($bannerAs as $bannerA) 
      <div class="col-md-3 visible-md visible-lg">
        <a href="{{$bannerA->link}}" target="_blank"><img src="/img-ad/{{$bannerA->filename}}" style="max-height:136px"></a>
      </div>
      @endforeach
      <span class="pull-right visible-md visible-lg" style="font-size:10px">
        <a href="{{(!is_null(Auth::user()))?'/member/advertising/place-ads':'/advertising'}}">Advertise Here&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</a>
      </span>
    </div>    

    <div class="row">
      <div class="alert footer"> 
        <form action="/search" method="get" class="visible-sm visible-md visible-lg">
          <div class="input-group pull-right" style="width:30%"> 
            <input class="form-control search" type="text" name="search" placeholder="Search Item" required>
            <span class="input-group-btn search">
              <button type="submit" class="btn btn-xs btn-default"><span class="glyphicon glyphicon-search"></span></button>
            </span>
          </div>
        </form>
      </div>
    </div>

    @yield('body')

    <div class="row" style="padding-top:30px">
      <div class="alert footer"></div>
      <div class="row visible-md visible-lg">
        <div class="col-sm-9 col-xs-12">
          <div class="col-sm-3 col-xs-3">
            <p class="footerTitle">New User</p>
            <a class="footerLink" href="/page-not-found">Help</a><br>
            <a class="footerLink" href="/page-not-found">How to Buy</a><br>
            <a class="footerLink" href="/page-not-found">How to Sell</a><br>
            <a class="footerLink" href="/page-not-found">How to Pay</a><br> 
            <br>
            <p class="footerTitle">Facebook</p>
            <a class="footerLink" href="/login">Facebook Login</a><br> 
            <a class="footerLink" href="/register">Facebook Register</a>   
          </div>

          <div class="col-sm-3 col-xs-3">
            <p class="footerTitle">Buy</p>
            <a class="footerLink" href="/page-not-found">Categories</a><br>
            <a class="footerLink" href="/page-not-found">Buy Now</a><br>     
            <br>
            <p class="footerTitle">My Account</p>
            <a class="footerLink" href="/register">Register to Buy & Sell</a><br>
            <a class="footerLink" href="/forgot/userid">Forgot User Id</a><br>
            <a class="footerLink" href="/forgot/password">Forgot Password</a>
          </div>

          <div class="col-sm-3 col-xs-3">
            <p class="footerTitle">Sell</p>
            <a class="footerLink" href="/page-not-found">Sell Item</a><br>
            <a class="footerLink" href="/page-not-found">How to Pay</a><br>
            <a class="footerLink" href="/page-not-found">How to Sell</a><br>    
            <br>
            <p class="footerTitle">Market Kounimap</p>
            <a class="footerLink" href="/page-not-found">About Market Kounimap</a><br>
            <a class="footerLink" href="/page-not-found">User Agreement</a><br>
            <a class="footerLink" href="/page-not-found">Privacy Policy</a>
          </div>

          <div class="col-sm-3 col-xs-3">
            <p class="footerTitle">Market Kounimap Web Store</p>
            <a class="footerLink" href="/page-not-found">Open a Web Store</a><br>
            <br>
            <p class="footerTitle">Kounimap</p>
            <a class="footerLink" href="/page-not-found">About Kounimap</a><br>
            <a class="footerLink" href="/page-not-found">Contact Kounimap</a><br>
            <a class="footerLink" href="/page-not-found">Location Map</a><br>
            <a class="footerLink" href="/feedback">Feedback to Kounimap</a>
          </div>
        </div>
        <div class="col-sm-3 col-xs-3 center visible-md visible-lg"><br>
          <img src="/img-system/logomarket01.jpg" alt="market kounimap" style="max-width:180px">
        </div>
      </div>
      <hr>
      <div class="col-xs-12 col-md-6">
        <p class="footerTitle" style="color:#999999">Copyright © 2014 Kounimap Idea. All Rights Reserved.
          <br>All product names are trademarks of their respective companies.
          <br>Market Kounimap is not affiliated with or endorsed by any company listed on this site.
        </p>
      </div>
      <div class="col-sm-6 visible-md visible-lg">
        <!--div class="fb-like" data-href="http://www.facebook.com/koperasi.unimap" data-layout="standard" data-action="like" data-show-faces="true" data-share="true">
        </div-->
      </div>
    </div>

    @yield('status-message')

    <!-- back to top -->
    <span id="top-link-block" class="hidden back-top visible-sm visible-md visible-lg">
      <a href="#top" class="well well-sm footer" onclick="$('html,body').animate({scrollTop:0},'slow');return false;">
        <span class="glyphicon glyphicon-chevron-up"></span> Back to Top
      </a>
    </span>
    <span id="top-link-block" class="hidden back-top visible-xs">
      <a href="#top" class="well well-sm footer" onclick="$('html,body').animate({scrollTop:0},'slow');return false;">
        <span class="glyphicon glyphicon-chevron-up"></span>
      </a>
    </span>
    <!-- end back to top -->

  </div> 
  <!-- END CONTAINER -->


<!-- Bootstrap core JavaScript
  ================================================== -->
  <!-- Placed at the end of the document so the pages load faster -->
  <script src="/js/jquery-1.11.1.min.js"></script>
  <script src="/js/bootstrap.min.js"></script>
  <script src="/js/jquery.form.js"></script>
  <script src="/js/image-upload.js"></script>
  <script src="/summernote/dist/summernote.min.js"></script>
  <script src="/jquery.dataTables/js/jquery.dataTables.min.js"></script>
  <script src="/js/check-availability.js"></script>
  @yield('script')
  @yield('script2')
  <script type="text/javascript">
  $(document).ready(function(){

    $('#sideMenuBar').mouseenter(function(){
      $('#sideMenuItem').animate({left:0});
    });

    $('#sideMenuItem').mouseleave(function(){
      $('#sideMenuItem').animate({left:-300});
    });

    $('.msg').delay(5000).fadeOut('slow');
    $('.arrow_box').delay(5000).fadeOut('slow'); 

    $('.summernote').summernote({
        height: 250,
        toolbar: [
        
        ['style', ['bold', 'italic', 'underline', 'clear']],
        ['font', ['strikethrough']],
        ['fontsize', ['fontsize']],
        ['color', ['color']],
        ['para', ['ul', 'ol', 'paragraph']],
        ['height', ['height']],
        ]
      });

    $('.dataTable').DataTable();

});//end windows ready
  </script>

<script>  // facebook
(function(d, s, id) {
  var js, fjs = d.getElementsByTagName(s)[0];
  if (d.getElementById(id)) return;
  js = d.createElement(s); js.id = id;
  js.src = "//connect.facebook.net/en_US/sdk.js#xfbml=1&appId=473922036052496&version=v2.0";
  fjs.parentNode.insertBefore(js, fjs);
}(document, 'script', 'facebook-jssdk'));
</script>

<script>
// Only enable if the document has a long scroll bar
// Note the window height + offset
if ( ($(window).height() + 100) < $(document).height() ) {
//$('.top-link-block').removeClass('hidden').affix({
  $('.back-top').removeClass('hidden').affix({
// how far to scroll down before link "slides" into view
offset: {top:100}
});
}
</script>

<script> // google analytic
(function(i,s,o,g,r,a,m){i['GoogleAnalyticsObject']=r;i[r]=i[r]||function(){
  (i[r].q=i[r].q||[]).push(arguments)},i[r].l=1*new Date();a=s.createElement(o),
  m=s.getElementsByTagName(o)[0];a.async=1;a.src=g;m.parentNode.insertBefore(a,m)
})(window,document,'script','//www.google-analytics.com/analytics.js','ga');

ga('create', 'UA-52771859-1', 'auto');
ga('send', 'pageview');
</script>

</body>
</html>