<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <meta name="description" content="Welcome to Market Kounimap, the best virtual shopping mall in Malaysia. Free registration or simple login using your facebook account.">
  <meta name="keywords" content="kounimap, unimap, kounimap idea, shopping, online, virtual shopping, shopping mall, free, buy online, online shop, perlis, roap, roapers">
  <meta name="author" content="Kounimap Idea">
  <meta name="robots" content="index, nofollow">
  <link rel="shortcut icon" href="/img-system/icon.png">

  <title>Market Kounimap - virtual shopping mall</title>

  <!-- Bootstrap core CSS -->
  <link href="/css/bootstrap.min.css" rel="stylesheet">
  <link href="/css/custom.css" rel="stylesheet">
  <link href="/font-awesome-4.1.0/css/font-awesome.min.css" rel="stylesheet">
  <style type="text/css">
  body {
    padding-top: 0px;
    padding-bottom: 10px;
  }
  </style>

  <!-- Just for debugging purposes. Don't actually copy this line! -->
  <!--[if lt IE 9]><script src="../../assets/js/ie8-responsive-file-warning.js"></script><![endif]-->

  <!-- HTML5 shim and Respond.js IE8 support of HTML5 elements and media queries -->
<!--[if lt IE 9]>
<script src="https://oss.maxcdn.com/libs/html5shiv/3.7.0/html5shiv.js"></script>
<script src="https://oss.maxcdn.com/libs/respond.js/1.4.2/respond.min.js"></script>
<![endif]-->
</head>

<body>

  <div class="navbar navbar-inverse navbar-fixed-top visible-xs" role="navigation">
    <div class="container">
      <!-- MOBILE TOP HEADER -->
      <div class="navbar-header" style="padding:5px">
        <div class="row">

          <div class="col-xs-2 center">
            <button type="button" class="btn btn-default btn-xs btn-block" data-toggle="collapse" data-target="#mobileCategory">
              <span class="glyphicon glyphicon-align-justify"></span>
            </button>
          </div>

          <div class="col-xs-8 center">
            <form action="/search-store/{{$store->id}}/{{Str::slug($store->shop_name)}}" method="get">
              <div class="input-group"> 
                <input class="form-control search" style="top:0px" type="text" name="search" placeholder="Search Item" required>
                <span class="input-group-btn">
                  <button type="submit" class="btn btn-xs btn-default"><span class="glyphicon glyphicon-search"></span></button>
                </span>
              </div>
            </form>
          </div>

          <div class="col-xs-2 center">
            <button type="button" class="btn btn-default btn-xs btn-block" data-toggle="collapse" data-target="#menu">
              <span class="glyphicon glyphicon-align-justify"></span>
            </button>
          </div>

        </div>
      </div>
      <!-- END MOBILE TOP HEADER -->

      <!-- MOBILE CATEGORY-->
      <div class="visible-xs">
        <div class="navbar-collapse collapse" id="mobileCategory">
          <ul class="nav navbar-nav navbar-right">
            <div class="alert footer center">Categories</div>
            <li><a href="/store/{{$store->id}}/{{Str::slug($store->shop_name)}}">All Items</a></li>
            @foreach($store_categorys as $store_category)
            <li>
              <a href="/store-category/{{$store->id}}/{{$store_category->category_id}}/{{Str::slug($store->shop_name)}}">
                {{$store_category->name}} ({{$store_category->countProduct}})
              </a>
            </li>
            @endforeach
          </ul>
        </div>
      </div>
      <!-- END MOBILE CATEGORY-->

      <!-- MOBILE MENU-->
      <div class="visible-xs">
        <div class="navbar-collapse collapse" id="menu">
          <ul class="nav navbar-nav navbar-right">
            <div class="alert footer center">Menu</div>
            <li><a href="/store/{{$store->id}}/{{Str::slug($store->shop_name)}}">Home</a></li>
            <li><a href="/delivery/{{$store->id}}/{{Str::slug($store->shop_name)}}">Delivery</a></li>
            <li><a href="/payment/{{$store->id}}/{{Str::slug($store->shop_name)}}">Payment</a></li>
            <li><a href="/news/{{$store->id}}/{{Str::slug($store->shop_name)}}">News</a></li>
            <li><a href="/about-us/{{$store->id}}/{{Str::slug($store->shop_name)}}">About Us</a></li>
            <li><a href="/contact-us/{{$store->id}}/{{Str::slug($store->shop_name)}}">Contact Us</a></li>
            <li><a href="/tnc/{{$store->id}}/{{Str::slug($store->shop_name)}}">T &amp; C</a></li>
          </ul>
        </div>
      </div>
      <!-- END MOBILE MENU-->
    </div>
  </div>

  <div class="container">
    <div class="visible-xs" style="height:40px"></div>
    <div class="row">
      <div class="col-sm-12">
        <p></p>
        @if($store->shop_banner!='')
        <a href="/store/{{$store->id}}/{{Str::slug($store->shop_name)}}">
          <img src="/img-banner/{{$store->shop_banner}}" alt="{{$store->shop_name}}" style="max-height:173px">
        </a>
        @endif
      </div>
    </div>

    <div class="row">
      <div class="alert footer">
        <div class="visible-sm visible-md visible-lg">
          <div class="storeBtn">
            <a href="/store/{{$store->id}}/{{Str::slug($store->shop_name)}}" class="btn btn-xs btn-default btn-store">Home</a>
            <a href="/delivery/{{$store->id}}/{{Str::slug($store->shop_name)}}" class="btn btn-xs btn-default btn-store">Delivery</a>
            <a href="/payment/{{$store->id}}/{{Str::slug($store->shop_name)}}" class="btn btn-xs btn-default btn-store">Payment</a>
            <a href="/news/{{$store->id}}/{{Str::slug($store->shop_name)}}" class="btn btn-xs btn-default btn-store">News</a>
            <a href="/about-us/{{$store->id}}/{{Str::slug($store->shop_name)}}" class="btn btn-xs btn-default btn-store">About Us</a>
            <a href="/contact-us/{{$store->id}}/{{Str::slug($store->shop_name)}}" class="btn btn-xs btn-default btn-store">Contact Us</a>
            <a href="/tnc/{{$store->id}}/{{Str::slug($store->shop_name)}}" class="btn btn-xs btn-default btn-store">T &amp; C</a>
          </div>
          <form action="/search-store/{{$store->id}}/{{Str::slug($store->shop_name)}}" method="get">
            <div class="input-group pull-right" style="width:30%"> 
              <input class="form-control search" type="text" name="search" placeholder="Search Item" required>
              <span class="input-group-btn search">
                <button type="submit" class="btn btn-xs btn-default"><span class="glyphicon glyphicon-search"></span></button>
              </span>
            </div>
          </form>
        </div>
      </div>
    </div>

    <div class="row">

      <!-- CATEGORY col 2 (left side column) -->
      <div class="col-sm-4 col-md-2 visible-sm visible-md visible-lg" style="padding-right:0px"> 
        <div class="panel panel-default">
          <div class="panel-heading"><b>Categories</b></div>
          <div class="panel-body">
            <table class="table table-hover" style="margin-bottom:0px">
              <tr>
                <th onclick="window.location.href='/store/{{$store->id}}/{{Str::slug($store->shop_name)}}'" style="cursor:pointer">All Items</th>
              </tr>
              @foreach($store_categorys as $store_category)
              <tr>
                <td onclick="window.location.href='/store-category/{{$store->id}}/{{$store_category->category_id}}/{{Str::slug($store->shop_name)}}'" style="cursor:pointer">
                  {{$store_category->name}} ({{$store_category->countProduct}})
                </td>
              </tr>
              @endforeach
            </table>
          </div>
        </div>
        <!-- FACEBBOK -->
        <div class="fb-like-box" data-href="http://www.facebook.com/{{$store->shop_fb}}" data-width="150px" data-colorscheme="light" data-show-faces="true" data-header="true" data-stream="false" data-show-border="true"></div>
      </div>  
      <!-- END CATEGORYend col 2 (left side column) -->

      <div class="col-sm-8 col-md-10">
        @yield('body')
      </div>

      <!-- back to top -->
      <span id="top-link-block" class="hidden back-top visible-sm visible-md visible-lg">
        <a href="#top" class="well well-sm footer" onclick="$('html,body').animate({scrollTop:0},'slow');return false;">
          <span class="glyphicon glyphicon-chevron-up"></span> Back to Top
        </a>
      </span>
      <span id="top-link-block" class="hidden back-top visible-xs">
        <a href="#top" class="well well-sm footer" onclick="$('html,body').animate({scrollTop:0},'slow');return false;">
          <span class="glyphicon glyphicon-chevron-up"></span>
        </a>
      </span>
      <!-- end back to top -->


    </div> <!-- /container -->

<!-- Bootstrap core JavaScript
  ================================================== -->
  <!-- Placed at the end of the document so the pages load faster -->
  <script src="/js/jquery-1.11.1.min.js"></script>
  <script src="/js/bootstrap.min.js"></script>
  <script>(function(d, s, id) {
    var js, fjs = d.getElementsByTagName(s)[0];
    if (d.getElementById(id)) return;
    js = d.createElement(s); js.id = id;
    js.src = "//connect.facebook.net/en_US/all.js#xfbml=1&appId=473922036052496";
    fjs.parentNode.insertBefore(js, fjs);
  }(document, 'script', 'facebook-jssdk'));
  </script>

  <script>
    // Only enable if the document has a long scroll bar
   // Note the window height + offset
   if ( ($(window).height() + 100) < $(document).height() ) {
    $('.back-top').removeClass('hidden').affix({
    // how far to scroll down before link "slides" into view
    offset: {top:100}
  });
  }
  </script>

<script> // google analytic
(function(i,s,o,g,r,a,m){i['GoogleAnalyticsObject']=r;i[r]=i[r]||function(){
  (i[r].q=i[r].q||[]).push(arguments)},i[r].l=1*new Date();a=s.createElement(o),
  m=s.getElementsByTagName(o)[0];a.async=1;a.src=g;m.parentNode.insertBefore(a,m)
})(window,document,'script','//www.google-analytics.com/analytics.js','ga');

ga('create', 'UA-52771859-1', 'auto');
ga('send', 'pageview');
</script>
</body>
</html>
