@extends('/store/template')
@section('body')

<h3>{{$product_categorys[0]->category->name}}</h3>
<hr>
<div class="panel panel-default">
  <div class="panel-heading"><b>Items</b></div>
  <div class="panel-body">
    <div class="row">
      @foreach($product_categorys as $product_category)
      <div class="col-md-2 col-xs-12">
        <div class="thumbnail">
          <a href="/product/{{$product_category->id}}/{{Str::slug($product_category->name)}}"><img src="/img-product/{{$product_category->imageThumbnail['name']}}" alt="{{$product_category->name}}" width="199px" style="min-height:136px;max-height:136px"></a>
          <div class="caption center">
            <div class="product-title"><a href="/product/{{$product_category->id}}/{{Str::slug($product_category->name)}}">{{$product_category->subName()}}</a></div>
            <div class="product-price">RM {{$product_category->sale_price}}</div>
          </div>
        </div>
      </div>
      @endforeach
    </div>
  </div>
</div> 

@stop