@extends('/store/template')
@section('body')
<h3>Result for "{{Request::get('search')}}"</h3>
<hr>
<div class="panel panel-default">
  <div class="panel-heading"><b>Items</b></div>
  <div class="panel-body">
    @if(count($products)==0)
    <div class="col-md-2">
      <h5>Product not found.</h5>
    </div>
    @endif
    <div class="row"> 
      @foreach($products as $product)
      <div class="col-md-2 col-xs-12">
        <div class="thumbnail">
          <a href="/product/{{$product->id}}/{{Str::slug($product->name)}}"><img src="/img-product/{{$product->imageThumbnail['name']}}" alt="{{$product->name}}" width="199px" style="min-height:136px;max-height:136px"></a>
          <div class="caption center">
            <div class="product-title"><a href="/product/{{$product->id}}/{{Str::slug($product->name)}}">{{$product->subName()}}</a></div>
            <div class="product-price">RM {{$product->sale_price}}</div>
          </div>
        </div> 
      </div>
      @endforeach
    </div>
  </div>
</div>

@stop