@extends('/store/template')
@section('body')

@if(count($featureds)>0)
<div class="panel panel-default">
  <div class="panel-heading"><b>Featured Items</b>
    <a class="pull-right fa fa-2x fa-arrow-circle-right" href="#featured_item" data-slide="prev"></a>
    <span class="pull-right">&nbsp;&nbsp;</span>
    <a class="pull-right fa fa-2x fa-arrow-circle-left" href="#featured_item" data-slide="next"></a>
  </div>
  <div class="panel-body">
    <div class="row">
      <div id="featured_item" class="carousel slide" data-interval="false">
        <!-- Carousel items -->
        <div class="carousel-inner">
          <?php $count=1; ?>
          @foreach($featureds as $featured)
          @if($count%12 == 1)
          <div class="item {{($count==1)?'active':''}}">
            @endif
            <div class="col-md-2 col-sm-4 col-xs-6">
              <div class="thumbnail">
                <a href="/product/{{$featured->id}}/{{Str::slug($featured->name)}}"><img src="/img-product/{{$featured->imageThumbnail['name']}}" alt="{{$featured->name}}" width="199px" style="min-height:136px;max-height:136px"></a>
                <div class="caption center">
                  <div class="product-title"><a href="/product/{{$featured->id}}/{{Str::slug($featured->name)}}">{{$featured->subName()}}</a></div>
                  <div class="product-price">RM {{$featured->sale_price}}</div>
                </div>
              </div>
            </div>
            @if ($count%12 == 0)</div>@endif
            <?php $count++ ?>
            @endforeach
            @if ($count%12 != 1) </div> @endif
          </div>
        </div>
      </div>
    </div>
  </div>
  @endif

  <div class="panel panel-default">
    <div class="panel-heading"><b>Items</b></div>
    <div class="panel-body">
      <div class="row"> 
       @foreach($news as $new)
       <div class="col-md-2 col-xs-12">
        <div class="thumbnail">
         <a href="/product/{{$new->id}}/{{Str::slug($new->name)}}"><img src="/img-product/{{$new->imageThumbnail['name']}}" alt="{{$new->name}}" width="199px" style="min-height:136px;max-height:136px"></a>
         <div class="caption center">
          <div class="product-title"><a href="/product/{{$new->id}}/{{Str::slug($new->name)}}">{{$new->subName()}}</a></div>
          <div class="product-price">RM {{$new->sale_price}}</div>
        </div>
      </div> 
    </div>
    @endforeach
  </div>
</div>
</div>

@if(count($bests)>0)
<div class="panel panel-default">
  <div class="panel-heading"><b>Best Selling Items</b>
    <a class="pull-right fa fa-2x fa-arrow-circle-right" href="#best_item" data-slide="prev"></a>
    <span class="pull-right">&nbsp;&nbsp;</span>
    <a class="pull-right fa fa-2x fa-arrow-circle-left" href="#best_item" data-slide="next"></a>
  </div>
  <div class="panel-body">
    <div class="row">
      <div id="best_item" class="carousel slide" data-interval="false">
        <!-- Carousel items -->
        <div class="carousel-inner">
          <?php $count=1; ?>
          @foreach($bests as $best)
          @if($count%12 == 1)
          <div class="item {{($count==1)?'active':''}}">
            @endif
            <div class="col-md-2 col-sm-4 col-xs-6">
              <div class="thumbnail">
                <a href="/product/{{$best->id}}/{{Str::slug($best->name)}}"><img src="/img-product/{{$best->imageThumbnail['name']}}" alt="{{$best->name}}" width="199px"></a>
                <div class="caption center">
                  <div class="product-title"><a href="/product/{{$best->id}}/{{Str::slug($best->name)}}">{{$best->subName()}}</a></div>
                  <div class="product-price">RM {{$best->sale_price}}</div>
                </div>
              </div>
            </div>
            @if ($count%12 == 0)</div>@endif
            <?php $count++ ?>
            @endforeach
            @if ($count%12 != 1) </div> @endif
          </div>
        </div>
      </div>
    </div>
  </div>
  @endif

  @stop