@extends('template')
@section('body')
<h3>Result for "{{Request::get('search')}}"</h3>
<hr>
<div class="row">
  <div class="col-sm-2 visible-sm visible-md visible-lg" style="padding-right:0px">
    <div class="panel panel-default">
      <div class="panel-heading"><b>Refine Search</b></div>
      <div class="panel-body">
        <div style="padding:5px">
          <b>Price Range (RM)</b>
          <form method="post">
            <input type="hidden" name="product_name" value="{{Request::get('search')}}">
            <input type="number" name="price_min" class="form-control">to
            <input type="number" name="price_max" class="form-control"><br>
            <button type="submit" class="btn btn-sm btn-warning">Search</button>
          </form>
        </div>
      </div>
    </div>
  </div>
  <div class="col-sm-10 col-xs-12">
    <div class="panel panel-default">
      <div class="panel-heading"><b>All Product</b></div>
      <div class="panel-body">
        @if(count($products)==0)
        <div class="col-xs-12">
          <h5>Product not found.</h5>
        </div>
        @endif
        @foreach($products as $product)
        <div class="col-md-2 col-sm-4 col-xs-6">
          <div class="thumbnail">
            <a href="/product/{{$product->id}}/{{Str::slug($product->name)}}"><img src="/img-product/{{$product->imageThumbnail['name']}}" alt="{{$product->name}}" width="199px" style="min-height:141px;max-height:141px"></a>
            <div class="caption">
              <div class="product-title">
                <a href="/product/{{$product->id}}/{{Str::slug($product->name)}}">{{$product->subName()}}</a>
              </div>
              <div class="product-title">
                <a href="/store/{{$product->profile_id}}/{{Str::slug($product->profile->shop_name)}}" class="shop-name">{{$product->profile->shop_name}}</a>
              </div>
              <div class="product-price center">RM {{$product->sale_price}}</div>
            </div>
          </div>
        </div>
        @endforeach
      </div>
    </div>
  </div>
  <!-- END PRODUCT -->

</div>
@stop