@extends('template')
@section('meta')
<!-- open graph object -->
<meta property="og:title" content="{{$product->name}}">
<meta property="og:image" content="http://market.kounimap.com/img-product/{{$product->imageThumbnail['name']}}"/>
<meta property="og:description" content="{{$product->description}}">
<meta property="og:url" content="{{Request::url()}}">
<meta property="og:type" content="website">
@stop
@section('body')

<div class="row">
  <div class="col-sm-2 visible-md visible-lg">
    <div class="panel panel-default">
      <div class="panel-heading"><b>SPECIAL</b></div>
      <div class="panel-body">
        <div id="carousel-example-generic" class="carousel slide" data-ride="carousel">

          <!-- Wrapper for slides -->
          <div class="carousel-inner">
            <?php $spA=1; ?>
            @foreach($specialAs as $specialA)
            <a href="{{$specialA->link}}" target="_blank" class="item {{($spA==1)?'active':''}}">
              <img src="/img-ad/{{$specialA->filename}}">
            </a>
            <?php $spA++; ?>
            @endforeach
          </div>

          <!-- Controls -->
          <a class="left carousel-control" href="#carousel-example-generic" data-slide="prev">
            <span class="glyphicon glyphicon-chevron-left"></span>
          </a>
          <a class="right carousel-control" href="#carousel-example-generic" data-slide="next">
            <span class="glyphicon glyphicon-chevron-right"></span>
          </a>
        </div>
      </div>
    </div>

  @if(count($featureds)>0)
    <div class="panel panel-default">
      <div class="panel-heading"><b>Featured Items</b></div>
      <div class="panel-body">
        @foreach($featureds as $featured)
        <div class="thumbnail">
          <a href="/product/{{$featured->id}}/{{Str::slug($featured->name)}}"><img src="/img-product/{{$featured->imageThumbnail['name']}}" alt="{{$featured->name}}"></a>
          <div class="caption">
            <div class="product-title"><a href="/product/{{$featured->id}}/{{Str::slug($featured->name)}}">{{$featured->subName()}}</a></div>
            <div class="product-price center">RM {{$featured->sale_price}}</div>
          </div>
        </div>
        @endforeach 
      </div>
    </div>
    @endif
  </div>

  <div class="col-sm-12 col-md-10">
    <div class="row">
      @if($product->profile->shop_banner!='')
      <div class="col-sm-12">
        <a href="/store/{{$product->profile->id}}/{{Str::slug($product->profile->shop_name)}}"><img src="/img-banner/{{$product->profile->shop_banner}}" alt="{{$product->profile->shop_name}}" width="100%" style="max-height:173px"></a>
      </div>
      @endif
      <div class="row">
        <div class="col-sm-12" style="padding-top:10px;padding-bottom:10px">
          <div class="col-sm-7 col-md-6">
            <div class="row">
              <div class="col-sm-12">
                <img class="large-thumbnail" src="/img-product/{{$product->imageThumbnail['name']}}" width="100%">
              </div>
            </div>
            <div class="row">
              <div class="col-sm-12" style="padding-top:10px;">
                <div class="row">
                  @foreach($product->image as $image)
                  <div class="col-xs-3 col-sm-3 col-md-3">
                    <div class="thumbnail small-thumbnail">
                      <img class="thumbnailHover" src="/img-product/{{$image->name}}" style='max-height:101px;min-height:101px'>
                    </div>
                  </div>
                  @endforeach
                </div>
              </div>
            </div>
          </div>
          <form action="/buy" method="post">
            <div class="col-sm-5 col-md-6">
              <div class="prod-name">{{$product->name}}</div>
              <table class="table">
                @if($product->retail_price!='')
                <tr>
                  <td>Retail Price</td>
                  <td><strike>RM {{$product->retail_price}}<strike></td>
                </tr>
                @endif
                <tr>
                  <td>Sale Price</td>
                  <td class="price">RM {{$product->sale_price}}</td>
                </tr>
                <tr>
                  <td>Shipping Fee</td>
                  <td>{{$product->shipping}}</td>
                </tr>
                <tr>
                  <td>Quantity</td>
                  <td>
                    <?php $qtty = $product->quantity; ?>
                    <select name="quantity">
                      @for($i=1; $i<=$qtty; $i++)
                      <option value="{{$i}}">{{$i}}</option>
                      @endfor
                    </select>
                  </td>
                </tr>
              </table>
              <input type="hidden" name="product_id" value="{{$product->id}}">
              <input type="hidden" name="profile_id" value="{{$product->profile_id}}">
              <button type="submit" class="btn btn-lg btn-danger btn-block">Buy Now</button>
              <a href="/store/{{$product->profile->id}}/{{Str::slug($product->profile->shop_name)}}" class="btn btn-lg btn-block btn-success">VISIT MY STORE</a><br>
              
              <!-- SOCIAL BUTTON -->
              <div class="visible-md visible-lg">
                <span class="g-plusone" data-action="share"></span><br>
                <span class="fb-share-button" data-href="{{URL::full()}}" data-type="button_count"></span></div>
              </div>
              <!-- END SOCIAL BUTTON -->
            </form>
          </div>
        </div>
        <div class="col-sm-12">
          <!-- Nav tabs -->
          <ul class="nav nav-tabs">
            <li class="active"><a href="#desc" data-toggle="tab">Description</a></li>
            <li><a href="#payment" data-toggle="tab">Payment</a></li>
            <li><a href="#delivery" data-toggle="tab">Delivery</a></li>
            <li><a href="#tnc" data-toggle="tab">T &amp; C</a></li>
            <li><a href="#policy" data-toggle="tab">Policy</a></li>
          </ul>

          <!-- Tab panes -->
          <div class="tab-content">
            <div class="tab-pane active" id="desc"><br>{{$product->description}}</div>
            <div class="tab-pane" id="payment"><br>{{$product->profile->shop_payment}}</div>
            <div class="tab-pane" id="delivery"><br>{{$product->profile->shop_delivery}}</div>
            <div class="tab-pane" id="tnc"><br>{{$product->profile->shop_tnc}}</div>
            <div class="tab-pane" id="policy"><br>{{$product->profile->shop_policy}}</div>
          </div>
        </div>


      </div>
    </div>
  </div>

  @if(count($bests)>0)
  <div class="row visible-md visible-lg">
    <div class="col-sm-12">
      <div class="panel panel-default">
        <div class="panel-heading"><b>Best Selling Items</b>
         <a class="pull-right fa fa-2x fa-arrow-circle-right" href="#best_seller" data-slide="prev"></a>
         <span class="pull-right">&nbsp;&nbsp;</span>
         <a class="pull-right fa fa-2x fa-arrow-circle-left" href="#best_seller" data-slide="next"></a>
       </div>
       <div class="panel-body">
         <div id="best_seller" class="carousel slide" data-interval="false">
          <!-- Carousel items -->
          <div class="carousel-inner">
            <?php $count=1; ?>
            @foreach($bests as $best)
            @if($count%6 == 1)
            <div class="item {{($count==1)?'active':''}}">
              @endif
              <div class="col-sm-2 col-xs-12">
                <div class="thumbnail">
                  <a href="/product/{{$best->id}}/{{Str::slug($best->name)}}"><img src="/img-product/{{$best->imageThumbnail['name']}}" alt="{{$best->name}}" width="199px"></a>
                  <div class="caption">
                    <div class="product-title"><a href="/product/{{$best->id}}/{{Str::slug($best->name)}}">{{$best->subName()}}</a></div>
                    <div class="product-price center">RM {{$best->sale_price}}</div>
                  </div>
                </div>
              </div>
              @if ($count%6 == 0)</div>@endif
              <?php $count++ ?>
              @endforeach
              @if ($count%6 != 1) </div> @endif
            </div>
          </div>
        </div><!-- end body-->
      </div>
    </div>
  </div> 
  @endif

  @stop

  @section('script')
  <script type="text/javascript">
  $(document).ready(function(){
    $('.small-thumbnail').click(function(){
      $('.large-thumbnail').attr('src',$(this).find("img").attr('src'));
    });

  // facebook share button
  (function(d, s, id) {
    var js, fjs = d.getElementsByTagName(s)[0];
    if (d.getElementById(id)) return;
    js = d.createElement(s); js.id = id;
    js.src = "//connect.facebook.net/en_US/sdk.js#xfbml=1&appId=473922036052496&version=v2.0";
    fjs.parentNode.insertBefore(js, fjs);
  }(document, 'script', 'facebook-jssdk'));

  // google plus share button
  (function() {
    var po = document.createElement('script'); po.type = 'text/javascript'; po.async = true;
    po.src = 'http://apis.google.com/js/platform.js';
    var s = document.getElementsByTagName('script')[0]; s.parentNode.insertBefore(po, s);
  })();
 
    })
</script>
@stop