@extends('template')
@section('body')

<div class="row">

  <div class="col-md-2">

    <div class="panel-group" id="accordion">

      <div class="panel panel-default">
        <a data-toggle="collapse" data-parent="#accordion" href="#profile">
          <div class="panel-heading accodian-menu"><h4 class="panel-title">My Profile</h4></div>
        </a>
        <div id="profile" class="panel-collapse collapse {{(Request::segment(2)=='profile')?'in':''}}">
          <div class="panel-body">
            <ol>
              <li {{(Request::segment(3)=='personal-detail')?"class='alert-info'":''}}><a href="/member/profile/personal-detail">Personal Detail</a></li>
              <li {{(Request::segment(3)=='personal-update')?"class='alert-info'":''}}><a href="/member/profile/personal-update">Personal Update</a></li>
            </ol>
          </div>
        </div>
      </div>

      <div class="panel panel-default">
        <a data-toggle="collapse" data-parent="#accordion" href="#buy">
          <div class="panel-heading accodian-menu"><h4 class="panel-title">My Buying</h4></div>
        </a>
        <div id="buy" class="panel-collapse collapse {{(Request::segment(2)=='buy')?'in':''}}">
          <div class="panel-body">
            <ol>
              <li {{(Request::segment(3)=='cart')?"class='alert-info'":''}}>
                <a href="/member/buy/cart">Cart
                  @if(Auth::user()->cartBil()!=0)
                  <span class='badge alert-danger'>
                    {{Auth::user()->cartBil()}}
                  </span>
                  @endif
                </a>
              </li>
              <li {{(Request::segment(3)=='order')?"class='alert-info'":''}}>
                <a href="/member/buy/order">My Order </a>
                @if(Auth::user()->countBuyOrderStatus('Pending')!=0)
                <a href="/member/buy/order/pending">
                  <span class='badge alert-danger'>{{Auth::user()->countBuyOrderStatus('Pending')}} Pe</span>
                </a>
                @endif
                @if(Auth::user()->countBuyOrderStatus('Approved')!=0)
                <a href="/member/buy/order/approved">
                  <span class='badge alert-success'>{{Auth::user()->countBuyOrderStatus('Approved')}} Ap</span>
                </a>
                @endif
              </li>
              <li {{(Request::segment(3)=='payment-confirmation')?"class='alert-info'":''}}><a href="/member/buy/payment-confirmation">Payment Confirmation</a></li>
            </ol>
          </div>
        </div>
      </div>

      <div class="panel panel-default">
        <a data-toggle="collapse" data-parent="#accordion" href="#sell">
          <div class="panel-heading accodian-menu"><h4 class="panel-title">My Sell</h4></div>
        </a>
        <div id="sell" class="panel-collapse collapse {{(Request::segment(2)=='sell')?'in':''}}">
          <div class="panel-body">
            @if(Auth::user()->profile->shop_name=='')
            <h6 class="center">register store first</h6>
            @else
            <ol>
              <li {{(Request::segment(3)=='product-list')?"class='alert-info'":''}}><a href="/member/sell/product-list">Product List</a></li>
              <li {{(Request::segment(3)=='product-add')?"class='alert-info'":''}}><a href="/member/sell/product-add">Add Product</a></li>
              <li {{(Request::segment(3)=='order')?"class='alert-info'":''}}>
                <a href="/member/sell/order">Order List</a>
                @if(Auth::user()->countSellOrderStatus('Pending')!=0)
                <a href="/member/buy/order/pending">
                  <span class='badge alert-danger'>{{Auth::user()->countSellOrderStatus('Pending')}} Pe</span>
                </a>
                @endif
                @if(Auth::user()->countSellOrderStatus('Approved')!=0)
                <a href="/member/buy/order/approved">
                  <span class='badge alert-success'>{{Auth::user()->countSellOrderStatus('Paid')}} Pa</span>
                </a>
                @endif
              </li>
            </ol>
            @endif
          </div>
        </div>
      </div>

      <div class="panel panel-default">
        <a data-toggle="collapse" data-parent="#accordion" href="#store">
          <div class="panel-heading accodian-menu"><h4 class="panel-title">My Store</h4></div>
        </a>
        <div id="store" class="panel-collapse collapse {{(Request::segment(2)=='store')?'in':''}}">
          <div class="panel-body">
            <ol>
              <li {{(Request::segment(3)=='manage-store')?"class='alert-info'":''}}><a href="/member/store/manage-store">Manage Store</a></li>
              <li {{(Request::segment(3)=='about-us')?"class='alert-info'":''}}><a href="/member/store/about-us">About Us</a></li>
              <li {{(Request::segment(3)=='payment')?"class='alert-info'":''}}><a href="/member/store/payment">Payment</a></li>
              <li {{(Request::segment(3)=='delivery')?"class='alert-info'":''}}><a href="/member/store/delivery">Delivery</a></li>
              <li {{(Request::segment(3)=='policy')?"class='alert-info'":''}}><a href="/member/store/policy">Policy</a></li>
              <li {{(Request::segment(3)=='tnc')?"class='alert-info'":''}}><a href="/member/store/tnc">Term &amp; Condition</a></li>
              <li style="color:#ecf0f1"><!--a href="/member/store/sale-report"-->Sale Report<!--/a--></li>
            </ol>
          </div>
        </div>
      </div>

      <div class="panel panel-default">
        <a data-toggle="collapse" data-parent="#accordion" href="#advertising">
          <div class="panel-heading accodian-menu"><h4 class="panel-title">Advertising</h4></div>
        </a>
        <div id="advertising" class="panel-collapse collapse {{(Request::segment(2)=='advertising')?'in':''}}">
          <div class="panel-body">
            <ol>
              <li {{(Request::segment(3)=='place-ads')?"class='alert-info'":''}}><a href="/member/advertising/place-ads">Place Ads</a></li>
              <li {{(Request::segment(3)=='list-ads')?"class='alert-info'":''}}><a href="/member/advertising/list-ads">List Ads</a></li>
            </ol>
          </div>
        </div>
      </div>

      <div class="panel panel-default">
        <a data-toggle="collapse" data-parent="#accordion" href="#account">
          <div class="panel-heading accodian-menu"><h4 class="panel-title">Account</h4></div>
        </a>
        <div id="account" class="panel-collapse collapse {{(Request::segment(2)=='change-password')?'in':''}}">
          <div class="panel-body">
            <ol>
              <li {{(Request::segment(2)=='change-password')?"class='alert-info'":''}}><a href="/member/change-password">Change Password</a></li>
              <li style="color:#ecf0f1">Delete Account</li>
            </ol>
          </div>
        </div>
      </div>

    </div><!-- end accordian -->
  </div><!-- end col 2 -->

  <div class="col-md-10" style="border-left:solid 2px #eee">
    <div style="min-height:350px">
      @yield('body2')
    </div>
  </div> <!-- end col 10 -->

</div><!-- end row -->


@stop

@section('status-message')

@if(Session::has('status') && Session::get('status') === true)
<div class="alert msg">
  <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
  <strong>Action Success</strong>
</div>
@endif
@if(Session::has('status') && !Session::get('status') )
<div class="alert msg">
  <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
  <strong>ERROR! Try again</strong>
</div>
@endif

@stop
