@extends('/member/template')
@section('body2')
<h3>Manage Store</h3>
<hr>
<div class="row">

  <form method="post" enctype="multipart/form-data">
    <div class="col-md-8"> 
      <div class="form-horizontal">
        <div class="form-group">
          <label class="col-md-3">Banner Image</label>
          <div class="col-sm-9">
            <input type="file" name="shop_banner"><br>
            @if(Auth::user()->profile->shop_banner)
            <img src="/img-banner/{{Auth::user()->profile->shop_banner}}">
            @endif
          </div>
        </div>
        <div class="form-group">
          <label class="col-md-3">Logo Image</label>
          <div class="col-sm-9">
            <input type="file" name="shop_logo"><br>
            @if(Auth::user()->profile->shop_logo)
            <img src="/img-logo/{{Auth::user()->profile->shop_logo}}" style="width:150px">
            @endif
          </div>
        </div>
        <div class="form-group">
          <label class="col-md-3">Store Name</label>
          <div class="col-sm-9">
            <input type="text" name="shop_name" value="{{Auth::user()->profile->shop_name}}" class="form-control" required>
          </div>
        </div>
        <div class="form-group">
          <label class="col-md-3">Facebook Url</label>
          <div class="col-sm-9">
            <div class="input-group">
              <span class="input-group-addon">http://www.facebook.com/</span>
              <input type="text" name="shop_fb" value="{{Auth::user()->profile->shop_fb}}" class="form-control">
            </div>
          </div>
        </div>
        <div class="form-group">
          <label class="col-md-3">Contact No</label>
          <div class="col-sm-9">
            <input type="text" name="shop_contact" value="{{Auth::user()->profile->shop_contact}}" class="form-control">
          </div>
        </div>
        <div class="form-group">
          <label class="col-md-3">Address</label>
          <div class="col-sm-9">
            <textarea class="form-control" name="shop_address" rows="4" required>{{Auth::user()->profile->shop_address}}</textarea>
          </div>
        </div>
        <div class="form-group">
          <div class="col-sm-offset-3 col-sm-8">
            <button type="submit" class="btn btn-warning">Save Changes</button>
          </div>
        </div>

      </div>
    </div>
  </form>

  <div class="col-md-4">
    <div class="alert alert-warning">
      <center><b>Important Notice</b></center><br>
      <b>Best Image Size</b>
      <ol>
        <li>Banner image : 1252W x 180H</li>
        <li>Logo image : 150W x 150H</li>
      </ol>
    </div>

  </div>

</div>

@stop

@section('status-message')

@if(Session::has('status') && Session::get('status') === true)
<div class="alert msg">
  <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
  <strong>Store Details Successful Update</strong>
</div>
@endif
@if(Session::has('status') && !Session::get('status') )
<div class="alert msg">
  <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
  <strong>ERROR! Try again</strong>
</div>
@endif

@stop
