@extends('/member/template')
@section('body2')

<h3>Add New Product</h3>
<hr>
<div class="row">
  <form method="post">
    <div class="col-md-7">
      <div class="form-horizontal">

        <div class="form-group">
          <label class="col-md-3">Category</label>
          <div class="col-sm-9">
            <select name="category_id" class="form-control" required>
              <option value="">Select category</option>
              @foreach($category_list as $list)
              <option value="{{$list->id}}">{{$list->name}}</option>
              @endforeach
            </select>
            <div class="checkbox">
              <label>
                <input type="checkbox" name="postFB" disabled> Post to Facebook wall
              </label>
            </div>
          </div>
        </div>
        <div class="form-group">
          <label class="col-md-3">Name</label>
          <div class="col-sm-9"><input type="text" name="name" class="form-control" required></div>
        </div>
        <div class="form-group">
          <label class="col-md-3">Retail Price</label>
          <div class="col-sm-9"><input type="number" step="any" name="retail_price" class="form-control"></div>
        </div>
        <div class="form-group">
          <label class="col-md-3">Sale Price</label>
          <div class="col-sm-9"><input type="number" step="any" name="sale_price" class="form-control" required></div>
        </div>
        <div class="form-group">
          <label class="col-md-3">Description</label>
          <div class="col-sm-9"><textarea class="form-control" name="description" rows="3" required></textarea></div>
        </div>
        <div class="form-group">
          <label class="col-md-3">Quantity</label>
          <div class="col-sm-9"><input type="number" name="quantity" class="form-control" required></div>
        </div>
        <div class="form-group">
          <label class="col-md-3">Shipping</label>
          <div class="col-sm-9"><input type="text" name="shipping" class="form-control" required></div>
        </div>
        <div class="form-group">
          <div class="col-md-12"><button type="submit" class="btn btn-warning pull-right">Save</button></div>
        </div>
      </div>
    </div>
  </form>

  <div class="col-md-5">
    <div class="row">
      <div class="col-md-12 drop-image">
        <div class="alert alert-warning">
          <b>NOTE :</b> For best image, make sure image size 511W x 511H.
        </div>
        <div id="validation-errors"></div>
        <form class="form-horizontal" id="upload" enctype="multipart/form-data" method="post" action="{{ url('upload/image') }}" autocomplete="off">
          <input type="hidden" name="_token" value="{{ csrf_token() }}" />
          <input type="file" name="image" id="image" /> 
        </form>
        <h6>Click <i style="color:red">Choose File</i> or <i style="color:red">Drag &amp; Drop</i> an image file on to black area.</h6>
      </div>

      <div class="col-md-12">
        <div class="progress progress-striped active" id="progBar" style="display:none">
          <div class="progress-bar" role="progressbar" aria-valuenow="100" aria-valuemin="0" aria-valuemax="100" style="width: 100%"></div>
        </div>
        <div id="output" style="display:none"></div>
      </div>
    </div>
  </div>
</div>

@stop

@section('status-message')

@if(Session::has('status') && Session::get('status') === true)
<div class="alert msg">
  <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
  <strong>Product Successful add</strong>
</div>
@endif
@if(Session::has('status') && !Session::get('status') )
<div class="alert msg">
  <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
  <strong>ERROR! Try again</strong>
</div>
@endif

@stop