@extends('/member/template')
@section('body2')

<h3>Order Details</h3>
<hr>
<div class="row">
	<div class="col-md-8">
		@if($orderDetail->latestStatus->status == 'Paid')
		<img src="/img-payment/{{$orderDetail->latestStatus->payment_image}}">
		@else
		<div class="panel panel-default">
			<div class="panel-heading"><h4>Invoice</h4></div>
			<div class="panel-body">

				<div class="panel-body" style="border:solid 1px #eee">
					<div class="col-md-2"><img src="/img-logo/{{$orderDetail->profile->shop_logo}}"></div>
					<div class="col-md-4">
						<h4>{{$orderDetail->profile->shop_name}}</h4>
						<h5>{{$orderDetail->profile->shop_address}}<br>{{$orderDetail->profile->officephone}}</h5>
					</div>
					<div class="col-md-12"><hr style="border:solid 1px #eee"></div>
					<div class="col-md-4">
						<h5 style="margin-top:0px"><b>{{$orderDetail->user->name}}</b><br>{{$orderDetail->user->profile->address}}</h5>
					</div>
					<div class="col-md-8 right top">
						<h5 style="margin-top:0px">{{$orderDetail->orderStatus[0]->tarikh}}</h5>
					</div>
					<div class="col-md-12">
						<h4 class="center">INVOICE</h4>
						<br>
						<span class="pull-right"><b>Order ID : {{$orderDetail->user_id}}/{{$orderDetail->id}}</b></span>
						<table class="table table-condensed table-bordered">
							<thead>
								<tr>
									<th class="center">#</th>
									<th class="center">Product Code</th>
									<th class="center">Description</th>
									<th class="center">Quantity</th>
									<th class="center">Unit Price</th>
									<th class="center">Amount</th>
								</tr>
							</thead>
							<tbody>
								<?php $i=1; $amount=$total=0;?>
								@foreach($orderDetail->orderDetails as $detail)
								<?php $amount = $detail->product->sale_price * $detail->quantity; ?>
								<tr>
									<td class="center">{{$i++}}</td>
									<td class="center">{{$detail->product_id}}</td>
									<td >{{$detail->product->name}}</td>
									<td class="center">{{$detail->quantity}}</td>
									<td class="right">{{$detail->product->sale_price}}</td>
									<td class="right">{{$amount}}<?php $total += $amount; ?></td>
								</tr>
								@endforeach
								@if($orderDetail->latestStatus->status == 'Approved')
								<tr>
									<td class="center">{{$i++}}</td>
									<td class="center">-</td>
									<td>Shipping charge</td>
									<td class="center">-</td>
									<td class="center">-</td>
									<td class="right">{{$orderDetail->delivery_charge}}
										<?php $total += $orderDetail->delivery_charge; ?>
									</td>
								</tr>
								@endif
							</tbody>
							<thead>
								<tr>
									<th colspan="5" class="right">Total Price</th>
									<th class="right">{{$total}}</th>
								</tr>
							</thead>
						</table>
					</div>
				</div>
			</div>
		</div>
		@endif
	</div>
	<div class="col-md-4">
		@if($orderDetail->latestStatus->status == 'Pending')
		<div class="panel panel-default">
			<div class="panel-heading"><h4>Approve</h4></div>
			<div class="panel-body">
				<div class="col-md-12">
					<form action="/member/sell/approve" method="post">
						<label>Shipping Cost</label>
						<input name="delivery_charge" class="form-control">
						<label>Description</label>
						<textarea rows="4" name="description" class="form-control"></textarea><br>
						<input type="hidden" name="order_id" value="{{$orderDetail->id}}">
						<button type="submit" class="btn btn-sm btn-warning">Approve</button>
					</form>
				</div>
			</div>
		</div>
		<hr>
		<div class="panel panel-default">
			<div class="panel-heading"><h4>Reject</h4></div>
			<div class="panel-body">
				<div class="col-md-12">
					<form action="/member/sell/reject" method="post">
						<label>Description</label>
						<textarea rows="4" name="description" class="form-control"></textarea><br>
						<input type="hidden" name="order_id" value="{{$orderDetail->id}}">
						<button type="submit" class="btn btn-sm btn-warning">Reject</button>
					</form>
				</div>
			</div>
		</div>
		@else
		<div class="panel panel-default">
			<div class="panel-heading"><h4>Status</h4></div>
			<div class="panel-body">
				<div class="col-md-12">
					<div class="form-horizontal">
						<div class="form-group">
							<label class="col-md-4">Status</label>
							<div class="col-sm-8">{{$orderDetail->latestStatus->status}}</div>
						</div>
						<div class="form-group">
							<label class="col-md-4">Date</label>
							<div class="col-sm-8">{{$orderDetail->latestStatus->tarikh}}</div>
						</div>
						<div class="form-group">
							<label class="col-md-4">Description</label>
							<div class="col-sm-8">{{$orderDetail->latestStatus->description}}</div>
						</div>
					</div>
				</div>
			</div>
		</div>
		@endif
	</div>
</div>
@stop