@extends('/member/template')
@section('body2')

<h3>Order List</h3>
<hr>
@if(count($order_lists)>0)
<table id="product" class="table table-striped" cellspacing="0" width="100%">
	<thead>
		<tr>
			<th class="center">Date</th>
			<th class="center">Order ID</th>
			<th class="center">Status</th>
			<th class="center">Buyer</th>
			<th></th>
		</tr>
	</thead>
	<tbody>
		@foreach($order_lists as $order_list)
		<tr>
			<td class="center">{{$order_list->tarikh}}</td>
			<td class="center">{{$order_list->user_id}}/{{$order_list->id}}</td>
			<td class="center">{{$order_list->status}}</td>
			<td class="center">{{$order_list->name}}</td>
			<td>
				<center>
					<div class="btn-group center">
						<a href="/member/sell/{{strtolower($order_list->status)}}/{{$order_list->id}}" class="btn btn-default btn-xs">Details</a>
					</div>
				</center>
			</td>
		</tr>
		@endforeach
	</tbody>
</table>
@else
<div class="col-md-12">
	No order.
</div>
@endif
@stop