@extends('/member/template')
@section('body2')

<h3>Personal Update</h3>
<hr>

<div class="row">
  <div class="col-md-2 visible-md visible-lg">
   @if(Auth::user()->profile->gender=='Male')
   <img src="/img-system/profileM.jpg">
   @else
   <img src="/img-system/profileF.jpg">
   @endif
 </div>
 <div class="col-md-6"> 
  <form class="form-horizontal" method="post">
    @if(Auth::user()->username=='')
    <h5 class="center" style="color:#f0ad4e">Create New User ID &amp; Password for basic login. Leave blank if not necessary.</h5>
    <div class="form-group">
      <label class="col-md-4">User ID</label>
      <div class="col-md-8">
        <div class="input-group">
          <input type="text" class="form-control" id="username" name="username">
          <span class="input-group-addon"><span class="fa fa-question" id="availableIcon"></span></span>
        </div><!-- /input-group -->
      </div>
      <div class="col-lg-4"></div>
      <div class="col-lg-8">
        <span class="alert-success" id="availableMsg0" style="display:none"><h5>User ID is valid.</h5></span>
        <span class="alert-danger" id="availableMsg1" style="display:none"><h5>User ID is not valid.</h5></span>
      </div>
    </div>
    <div class="form-group">
      <label class="col-md-4">Password</label>
      <div class="col-md-8">
        <input type="password" class="form-control" name="password">
      </div>
    </div>
    <hr>
    @endif
    <div class="form-group">
      <label class="col-md-4">Name</label>
      <div class="col-md-8">
        <input type="text" class="form-control" name="name" value="{{Auth::user()->name}}">
      </div>
    </div>
    <div class="form-group">
      <label class="col-md-4">No IC / Passport</label>
      <div class="col-md-8">
        <input type="text" class="form-control" name="no_ic" value="{{Auth::user()->profile->no_ic}}" required>
      </div>
    </div>
    <div class="form-group">
      <label class="col-md-4">Gender</label>
      <div class="col-md-8">
        <input type="radio" name="gender" value="Male" {{(Auth::user()->profile->gender=='Male')?'checked':''}}  required> Male
        <input type="radio" name="gender" value="Female" {{(Auth::user()->profile->gender=='Female')?'checked':''}}  required> Female
      </div>
    </div>
    <div class="form-group">
      <label class="col-md-4">Birthdate</label>
      <div class="col-md-8">
        <input type="date" class="form-control" name="birthdate" value="{{Auth::user()->profile->birthdate}}" required>
      </div>
    </div>
    <div class="form-group">
      <label class="col-md-4">Address</label>
      <div class="col-md-8">
        <textarea class="form-control" name="address" required>{{Auth::user()->profile->address}}</textarea>
      </div>
    </div>
    <div class="form-group">
      <label class="col-md-4">Home Phone No</label>
      <div class="col-md-8">
        <input type="text" class="form-control" name="homephone" value="{{Auth::user()->profile->homephone}}">
      </div>
    </div>
    <div class="form-group">
      <label class="col-md-4">Office Phone No</label>
      <div class="col-md-8">
        <input type="text" class="form-control" name="officephone" value="{{Auth::user()->profile->officephone}}">
      </div>
    </div>
    <div class="form-group">
      <label class="col-md-4">Handphone No</label>
      <div class="col-md-8">
        <input type="text" class="form-control" name="handphone" value="{{Auth::user()->profile->handphone}}" required>
      </div>
    </div>
    <div class="form-group">
      <label class="col-md-4">Email</label>
      <div class="col-md-8">
        <input type="email" class="form-control" name="email" value="{{Auth::user()->profile->email}}">
      </div>
    </div>
    <div class="form-group">
      <div class="col-md-offset-4 col-md-8"><button type="submit" class="btn btn-warning">Save Changes</button></div>
    </div>
  </form>
</div>
<div class="col-md-4">
   <!--div class="alert alert-warning">
    <center><b>Important Notice</b></center>
  </div-->
</div>
</div>

@stop

@section('script')
<script src="/js/check-availability.js"></script>
@stop

@section('status-message')

@if(Session::has('status') && Session::get('status') === true)
<div class="alert msg">
  <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
  <strong>Personal Details Successful Update</strong>
</div>
@endif
@if(Session::has('status') && !Session::get('status') )
<div class="alert msg">
  <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
  <strong>ERROR! Try again</strong>
</div>
@endif

@stop