@extends('/member/buy/order')

@section('status')
<div class="panel panel-default">
	<div class="panel-heading"><h4>Order Details</h4></div>
	<div class="panel-body">

		<div class="panel-body" style="border:solid 1px #eee">
			<div class="col-md-2"><img src="/img-logo/{{$orderDetail->profile->shop_logo}}"></div>
			<div class="col-md-4">
				<h4>{{$orderDetail->profile->shop_name}}</h4>
				<h5>{{$orderDetail->profile->shop_address}}<br>{{$orderDetail->profile->officephone}}</h5>
			</div>
			<div class="col-md-12"><hr style="border:solid 1px #eee"></div>
			<div class="col-md-4">
				<h5 style="margin-top:0px"><b>{{$orderDetail->user->name}}</b><br>{{$orderDetail->user->profile->address}}</h5>
			</div>
			<div class="col-md-8 right top">
				<h5 style="margin-top:0px">{{$orderDetail->orderStatus[0]->tarikh}}</h5>
			</div>
			<div class="col-md-12">
				<h4 class="center">INVOICE</h4>
				<br>
				<span class="pull-right"><b>Order ID : {{$orderDetail->user_id}}/{{$orderDetail->id}}</b></span>
				<table class="table table-condensed table-bordered">
					<thead>
						<tr>
							<th class="center">#</th>
							<th class="center">Product Code</th>
							<th class="center">Description</th>
							<th class="center">Quantity</th>
							<th class="center">Unit Price</th>
							<th class="center">Amount</th>
						</tr>
					</thead>
					<tbody>
						<?php $i=1; $amount=$total=0;?>
						@foreach($orderDetail->orderDetails as $detail)
						<?php $amount = $detail->unit_price * $detail->quantity; ?>
						<tr>
							<td class="center">{{$i++}}</td>
							<td class="center">{{$detail->product_id}}</td>
							<td >{{$detail->product->name}}</td>
							<td class="center">{{$detail->quantity}}</td>
							<td class="right">{{$detail->unit_price}}</td>
							<td class="right">{{$amount}}<?php $total += $amount; ?></td>
						</tr>
						@endforeach
					</tbody>
					<thead>
						<tr>
							<th colspan="5" class="right">Total Price</th>
							<th class="right">{{$total}}</th>
						</tr>
					</thead>
				</table>
				<div class="asterisk">
					*Total Price exclude delivery charge.<br>*This invoice not a finalize invoice.
				</div>
			</div>
		</div>
	</div>
</div>
@stop