@extends('/member/template')
@section('body2')

<h3>Payment Confirmation</h3>
<hr>
<div class="row">
	<div class="col-md-4">
		<b>Select Order ID</b>
		<select id="status_id" class="form-control">
			<option value=""> - Select - </option>
			@foreach($orders as $order)
			<option value="{{$order->id}}"{{($order->id==Request::segment(4))?'selected':''}}>{{$order->user_id}}/{{$order->order_id}}</option>
			@endforeach
		</select>
	</div>
	@if(count($order_status)>0)
	<div class="col-md-8">
		<div class="panel panel-default">
			<div class="panel-heading"><h4>Upload Payment Slip</h4></div>
			<div class="panel-body">
				<div class="alert alert-warning">
					<b>NOTE :</b> Image file only. Format : .jpeg / .jpg / .png
				</div>
				<br>
				@if($order_status->payment_image != '')
				<form class="form-horizontal" method="post" enctype="multipart/form-data">
					<div class="form-group">
						<div class="col-md-offset-2 col-md-6">
							<input type="file" name="payment_image" required>
							<input type="hidden" name="status_id" value="{{$order_status->id}}">
						</div>
						<div class="col-lg-4">
							<button type="submit" class="btn btn-warning">Update</button>
						</div>
					</div>
				</form>
				@else
				<form class="form-horizontal" method="post" enctype="multipart/form-data">
					<div class="form-group">
						<div class="col-md-offset-2 col-md-6">
							<input type="file" name="payment_image" required>
							<input type="hidden" name="order_id" value="{{$order_status->order_id}}">
						</div>
						<div class="col-lg-4">
							<button type="submit" class="btn btn-warning">Submit</button>
						</div>
					</div>
				</form>
				@endif
			</div>
		</div>
	</div>
	@endif
</div>
@stop

@section('script')
<script type="text/javascript">
$(document).ready(function(){

	$('#status_id').on('change',function(){
		document.location.href = '/member/buy/payment-confirmation/' + $(this).val();
	});

});
</script>
@stop

