@extends('/member/template')
@section('body2')

<h3>Order List</h3>
<hr>
<div class="row">
	<div class="col-md-4">
		<div class="form-horizontal">
			<div class="form-group">
				<label class="col-md-2 control-label">Status</label>
				<div class="col-sm-10">
					<select id="status" class="form-control">
						<option value="pending" {{$orderStatus=='pending'?'selected':''}}>Pe - Pending</option>
						<option value="approved" {{$orderStatus=='approved'?'selected':''}}>Ap - Approved</option>
						<option value="paid" {{$orderStatus=='paid'?'selected':''}}>Pa - Paid</option>
						<option value="delivery" {{$orderStatus=='delivery'?'selected':''}}>De - Delivery</option>
						<option value="received" {{$orderStatus=='received'?'selected':''}}>Rc - Received</option>
						<option value="rejected" {{$orderStatus=='rejected'?'selected':''}}>Rj - Rejected</option>
					</select>					
				</div>
			</div>
		</div>
		@if($orderLists)
		<table class="table table-condensed">
			<thead>
				<tr>
					<th class="center">#</th>
					<th class="center">Order ID</th>
					<th class="center">Datetime</th>
					<th></th>
				</tr>
			</thead>
			<tbody>
				<?php $no=1; ?>
				@foreach($orderLists as $orderList)
				<tr>
					<td class="center">{{$no++}}</td>
					<td class="center">{{$orderList->user_id}}/{{$orderList->order_id}}</td>
					<td class="center">{{$orderList->tarikh}}</td>
					<td>
						<center>
							<a href="/member/buy/{{$orderStatus}}/{{$orderList->order_id}}" class="btn btn-xs btn-default">Details</a>
						</center>
					</td>
				</tr>
				@endforeach
			</tbody>
		</table>
		@else
		<h5 style="color:#f0ad4e">Not available.</h5>
		@endif
	</div>

	<div class="col-md-8">
		@section('status')
		<div class="panel panel-default">
			<div class="panel-heading"><h4>Notice</h4></div>
			<div class="panel-body">
				<ol>
					<li><b>Pending :</b> 
						Invoice generate by system after buyer confirm order. 
						Wait for seller approve the order.
						The invoice generated NOT include shipping charge.
						Final cost maybe change after approve by seller.
					</li>
					<li><b>Approved :</b>
						Order approved by seller.
						Buyer need to make payment within 2 days after approved date.
						After make payment, upload the payment slip at <a href="/member/buy/payment-confirmation">Payment Confirmation</a> section. 
					</li>
					<li><b>Paid :</b>
						Waiting for seller validate the payment slip.
					</li>
					<li><b>Delivery :</b>
						Product in process delivery. Delivery status will update by seller.
						Please update when product received by giving product rating and shop rating.
					</li>
					<li><b>Received :</b>
						List successfull order.
					</li>
					<li><b>Reject :</b>
						List rejected order.
					</li>
				</ol>

			</div>
		</div>
		@show
	</div>

</div>
@stop

@section('script')
<script type="text/javascript">
$(document).ready(function(){

	$('#status').change(function(){
		document.location.href = '/member/buy/order/' + $(this).val();
	});

});
</script>
@stop