@extends('/member/buy/order')

@section('status')
<div class="panel panel-default">
	<div class="panel-heading"><h4>Order Details</h4></div>
	<div class="panel-body">
		<div class="col-md-12">
			<div class="form-horizontal">
				<div class="form-group">
					<label class="col-md-2">Status</label>
					<div class="col-md-10">
						{{$orderDetail->latestStatus->status}}
					</div>
				</div>
				<div class="form-group">
					<label class="col-md-2">Date</label>
					<div class="col-md-10">
						{{$orderDetail->latestStatus->tarikh}}
					</div>
				</div>
				<div class="form-group">
					<label class="col-md-2">Description</label>
					<div class="col-md-10">
						{{$orderDetail->latestStatus->description}}
					</div>
				</div>
			</div>
		</div>
	</div>
</div>
<div class="panel panel-default">
	<div class="panel-heading"><h4>I have received the goods</h4></div>
	<div class="panel-body">
		<div class="col-md-12">
			<form action="/member/buy/received" method="post">
				<div class="form-horizontal">
					<div class="form-group">
						<label class="col-md-3">Product Rate</label>
						<div class="col-md-9">						
							<span class="ratingA cursor fa fa-star-o fa-2x" data="1"></span>
							<span class="ratingA cursor fa fa-star-o fa-2x" data="2"></span>
							<span class="ratingA cursor fa fa-star-o fa-2x" data="3"></span>
							<span class="ratingA cursor fa fa-star-o fa-2x" data="4"></span>
							<span class="ratingA cursor fa fa-star-o fa-2x" data="5"></span>
						</div>
					</div>
					<div class="form-group">
						<label class="col-md-3">Shop Service Rate</label>
						<div class="col-md-9">						
							<span class="ratingB cursor fa fa-star-o fa-2x" data="1"></span>
							<span class="ratingB cursor fa fa-star-o fa-2x" data="2"></span>
							<span class="ratingB cursor fa fa-star-o fa-2x" data="3"></span>
							<span class="ratingB cursor fa fa-star-o fa-2x" data="4"></span>
							<span class="ratingB cursor fa fa-star-o fa-2x" data="5"></span>
						</div>
					</div>
					<div class="form-group">
						<label class="col-md-3">Feedback</label>
						<div class="col-md-9 ">						
							<textarea class="form-control" name="feedback" rows="4"></textarea>
						</div>
					</div>
					<div class="form-group">
						<div class="col-md-3"></div>		
						<div class="col-md-9">	
							<input type="hidden" name="order_id" value="{{$orderDetail->id}}">	
							<input type="hidden" name="rating_product" id="rating_product" value="0">	
							<input type="hidden" name="rating_store" id="rating_store" value="0">	
							<button type="submit" class="btn btn-sm btn-warning">&nbsp;Submit&nbsp;</button>
						</div>
					</div>
				</div>
			</form>
		</div>
	</div>
</div>
@stop

@section('script2')
<script type="text/javascript">
$(document).ready(function(){
	$('.ratingA').click(function(){
		$('.ratingA').attr('class','ratingA cursor fa fa-star-o fa-2x');
		value = $(this).attr('data');
		for(i=1; i<=value; i++){
			$('.ratingA[data="'+i+'"]').attr('class','ratingA cursor fa fa-star fa-2x');
		}
		$('#rating_product').val(value);
	});
	$('.ratingB').click(function(){
		$('.ratingB').attr('class','ratingB cursor fa fa-star-o fa-2x');
		value = $(this).attr('data');
		for(i=1; i<=value; i++){
			$('.ratingB[data="'+i+'"]').attr('class','ratingB cursor fa fa-star fa-2x');
		}
		$('#rating_store').val(value);
	});
})
</script>
@stop