@extends('template')
@section('body')
<div class="row">

	<div class="col-md-12">
		<h3>Order Confirmation</h3>
		<hr>
		@if($company)
		<div class="col-md-8">
			<form action="/member/buy/confirm-order" method="post">
				<div class="panel-body" style="border:solid 1px #eee">
					<div class="col-md-2"><img src="/img-logo/{{$company->shop_logo}}"></div>
					<div class="col-md-4">
						<h4>{{$company->shop_name}}</h4>
						<h5>{{$company->shop_address}}<br>{{$company->officephone}}</h5>
					</div>
					<div class="col-md-12"><hr style="border:solid 1px #eee"></div>
					<div class="col-md-4">
						<h5 style="margin-top:0px"><b>{{Auth::user()->name}}</b><br>{{Auth::user()->profile->address}}</h5>
					</div>
					<div class="col-md-8 right top">
						<h5 style="margin-top:0px">{{date('d-m-Y')}}</h5>
					</div>
					<div class="col-md-12">
						<h4 class="center">INVOICE</h4>
						<br>
						<table class="table table-condensed table-bordered">
							<thead>
								<tr>
									<th class="center">#</th>
									<th class="center">Product Code</th>
									<th class="center">Description</th>
									<th class="center">Quantity</th>
									<th class="center">Unit Price</th>
									<th class="center">Amount</th>
								</tr>
							</thead>
							<tbody>
								<?php $i=1; $amount=$total=0;?>
								@foreach($carts as $cart)
								<?php $amount = $cart->product->sale_price * $cart->quantity; ?>
								<tr>
									<td class="center">{{$i++}}</td>
									<td class="center">{{$cart->product_id}}</td>
									<td >{{$cart->product->name}}</td>
									<td class="center">{{$cart->quantity}}</td>
									<td class="right">{{$cart->product->sale_price}}</td>
									<td class="right">{{$amount}}<?php $total += $amount; ?></td>
									<input type="hidden" name="cart_id[]" value="{{$cart->id}}">
								</tr>
								@endforeach
							</tbody>
							<thead>
								<tr>
									<th colspan="5" class="right">Total Price</th>
									<th class="right">{{$total}}</th>
								</tr>
							</thead>
						</table>
						<div class="asterisk">*Total Price exclude delivery charge.</div>
					</div>
					<div class="col-md-12 center">
						<h6>
							Please check order status in 24 hours after confirmation.
							<br>Thank You for Shopping with Us.
						</h6>
					</div>
				</div>
				<br>
				<button type="submit" class="btn btn-warning pull-right" onclick="return confirm('I have read all the notices and agree all term and conditon.')">Confirm Order</button>
			</form>
		</div>
		@else
		<div class="col-md-8">
			No Order
		</div>
		@endif
		<div class="col-md-4">
			<div class="panel panel-default">
				<div class="panel-heading"><h4>Notice</h4></div>
				<div class="panel-body">
					<ol>
						<li>{{$company->shop_name}}'s <a href="/tnc/{{$company->id}}" target="_blank">Term &amp; Condition</a></li>
						<li>Kounimap's <a href="">Term &amp; Condition</a></li>
					</ol>
				</div>
			</div>
		</div>


	</div><!-- end col 12 -->

</div><!-- end row -->

@stop