@extends('/member/template')
@section('body2')

<h3>My Shopping Cart</h3>
<hr>

<div class="row">
	@foreach($sellers as $seller)
	<div class="col-md-12">
		<h4>Product purchase from {{$seller[0]->profile->shop_name}}</h4>
	</div>
	<div class="col-md-12" style="padding-bottom:30px">
		<form action="/member/buy/checkout/{{$seller[0]->profile_id}}" method="post">
			<table class="table table-condensed">
				<thead>
					<tr>
						<th>Picture</th>
						<th>Item</th>
						<th class="right">Price (RM)</th>
						<th class="center">Quantity</th>
						<th class="center">Subtotal (RM)</th>
						<th></th>
					</tr>
				</thead>
				<tbody>
					@foreach($seller as $cart)
					<tr>
						<td><img src="/img-product/{{$cart->product->imageThumbnail['name']}}" style="width:70px"></td>
						<td><a href="/product/{{$cart->product->id}}">{{$cart->product->name}}</a></td>
						<td class="right">{{$cart->product->sale_price}}</td>
						<td class="center">
							<?php $qtty = $cart->product->quantity; ?>
							<select name="quantity-{{$cart->id}}">
								@for($i=1; $i<=$qtty; $i++)
								<option value="{{$i}}" {{($cart->quantity==$i)?'selected':''}}>{{$i}}</option>
								@endfor
							</select>
						</td>
						<td></td>
						<td><a href=""><span class="glyphicon glyphicon-remove"></span></a></td>
					</tr>
					@endforeach
				</tbody>
				<thead>
					<tr>
						<th colspan="4" class="right">Total Price</th>
						<th class="right">0000.00</th>
						<th></th>
					</tr>
				</thead>
			</table>
			<button type="submit" class="btn btn-warning pull-right">Proceed to Checkout</button>
			<span class="pull-right">&nbsp;&nbsp;&nbsp;</span>
			<a href="/store/{{$cart->profile_id}}" class="btn btn-default pull-right">Continue Shopping</a>
		</form>  
	</div>
	<div class="col-md-12"><hr style="border:solid 1px #eee"></div>
	@endforeach

	@if(count($sellers)==0)
	<div class="col-md-12">
		<h2><span class="glyphicon glyphicon-shopping-cart"></span> Your shopping cart is empty.</h2>
		<a href="/" class="btn btn-warning">Shop Now</a>
	</div>
	@endif
</div>

@stop