@extends('/member/template')
@section('body2')

<h3>Place Ads</h3>
<hr>

<div class="row">

  <div class="col-md-6">
    <form class="form-horizontal" method="post" enctype="multipart/form-data">
      <div class="form-group">
        <label class="col-md-2 control-label">Type</label>
        <div class="col-md-10">
          <select name="type" class="form-control">
            @foreach($bannerTypes as $bannerType)
            <option value="{{$bannerType->type}}" {{(Request::segment('2')==$bannerType->type)?'selected':''}}>
              {{$bannerType->type}}
            </option>
            @endforeach
          </select>
        </div>
      </div>
      <div class="form-group">
        <label class="col-md-2 control-label">Period</label>
        <div class="col-md-10">
          <div class="radio">
            <label>
              <input type="radio" name="period" value="1 Week" checked>1 Week
            </label>
          </div>
          <div class="radio">
            <label>
              <input type="radio" name="period" value="1 Month">1 Month
            </label>
          </div>
        </div>
      </div>
      <div class="form-group">
        <label class="col-md-2 control-label">Link</label>
        <div class="col-md-10">
          <input type="text" class="form-control" name="link" required>
        </div>
      </div>
      <div class="form-group">
        <label class="col-md-2 control-label">Image</label>
        <div class="col-md-10">
          <h5><input type="file" name="image" required></h5>
        </div>
      </div>

      <div class="form-group">
        <div class="col-lg-12 right">
          <button type="submit" class="btn btn-warning">Submit</button>
        </div>
      </div>

    </form>

  </div>

  <div class="col-md-6 visible-md visible-lg">
    <div class="panel panel-default">
      <div class="panel-heading"><h4>Note</h4></div>
      <div class="panel-body">
        <div class="col-md-12">
          <table class="table">
            <thead>
              <tr>
                <th>Type</th>
                <th class="center">Image Size (W x H)</th>
                <th class="center">Price</th>
                <th></th>
              </tr>
            </thead>
            <tbody>
              <tr>
                <td>BannerA</td>
                <td class="center">290 x 100 pixel</td>
                <td>RM 150 / week<br>RM 300 / month</td>
                <td><a href="/advertising" target="_blank">Details</a></td>
              </tr>
              <tr>
                <td>SpecialA</td>
                <td class="center">172 x 224 pixel</td>
                <td>RM 100 / week<br>RM 200 / month</td>
                <td><a href="/advertising" target="_blank">Details</a></td>
              </tr>
              <tr>
                <td>BannerB1</td>
                <td class="center">611 x 211 pixel</td>
                <td>RM 50 / week<br>RM 150 / month</td>
                <td><a href="/advertising" target="_blank">Details</a></td>
              </tr>
              <tr>
                <td>BannerB2</td>
                <td class="center">611 x 211 pixel</td>
                <td>RM 50 / week<br>RM 150 / month</td>
                <td><a href="/advertising" target="_blank">Details</a></td>
              </tr>
            </tbody>
          </table>
        </div>
      </div>
    </div>
  </div>
</div>

@stop

@section('status-message')

@if(Session::has('status') && Session::get('status') === true)
<div class="alert msg">
  <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
  <strong>Ads Request Success</strong>
</div>
@endif
@if(Session::has('status') && !Session::get('status') )
<div class="alert msg">
  <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
  <strong>ERROR! Try again</strong>
</div>
@endif

@stop