@extends('/member/template')
@section('body2')

<h3>List Ads</h3>
<hr>
<table class="table table-striped table-bordered dataTable" cellspacing="0" width="100%">
	<thead>
		<tr>
			<th>Id</th>
			<th>Type</th>
			<th class="center">Price</th>
			<th class="center">Period</th>
			<th class="center">Start date</th>
			<th class="center">End date</th>
			<th class="center">Status</th>
			<th></th>
		</tr>
	</thead>
	<tbody>
		@foreach($list_ads as $list_ad)
		<tr>
			<td>{{$list_ad->user_id}}/{{$list_ad->id}}</td>
			<td>{{$list_ad->type}}</td>
			<td class="center">{{$list_ad->price}}</td>
			<td class="center">{{$list_ad->period}}</td>
			<td class="center">{{$list_ad->start_date}}</td>
			<td class="center">{{$list_ad->end_date}}</td>
			<td class="center">{{$list_ad->status}}</td>
			<td class="center">
				<a href="/member/advertising/cancel-ads/{{$list_ad->id}}" onclick="return confirm('Ads will be deactivate.')" class="btn btn-xs btn-danger">Cancel</a>
			</td>
		</tr>
		@endforeach
	</tbody>
</table>

@stop

@section('status-message')

@if(Session::has('status') && Session::get('status') === true)
<div class="alert msg">
  <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
  <strong>Ads Deactivate Success</strong>
</div>
@endif
@if(Session::has('status') && !Session::get('status') )
<div class="alert msg">
  <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
  <strong>ERROR! Try again</strong>
</div>
@endif

@stop
