@extends('template')
@section('body')

@if(count($premiums)>0)
<div class="row">
 <div class="col-sm-2 visible-lg visible-md">
  <div class="panel panel-default">
    <div class="panel-heading"><b>SPECIAL</b></div>
    <div class="panel-body">
      <div id="specialA" class="carousel slide" data-ride="carousel">
        <!-- Wrapper for slides -->
        <div class="carousel-inner">
          <?php $spA=1; ?>
          @foreach($specialAs as $specialA)
          <a href="{{$specialA->link}}" target="_blank" class="item {{($spA==1)?'active':''}}">
            <img src="/img-ad/{{$specialA->filename}}" style="max-height:273px;min-height:273px">
          </a>
          <?php $spA++; ?>
          @endforeach
        </div>
        <!--button class="btn btn-lg btn-block btn-default" disabled>GRAB NOW</button-->
        <!-- Controls -->
        <a class="left carousel-control" href="#specialA" data-slide="prev">
          <span class="glyphicon glyphicon-chevron-left"></span>
        </a>
        <a class="right carousel-control" href="#specialA" data-slide="next">
          <span class="glyphicon glyphicon-chevron-right"></span>
        </a>
      </div>
    </div>
    <span class="center visible-lg visible-md" style="font-size:10px">
      <a href="{{(!is_null(Auth::user()))?'/member/advertising/place-ads':'/advertising'}}">Place your special product here</a>
    </span>
  </div>
</div>

<!-- PREMIUM PRODUCT -->
<div class="col-xs-12 col-md-10">
  <div class="panel panel-default">
    <div class="panel-heading"><b>Premium Featured</b>
      <a class="pull-right fa fa-2x fa-arrow-circle-right" href="#premium" data-slide="prev"></a>
      <span class="pull-right">&nbsp;&nbsp;</span>
      <a class="pull-right fa fa-2x fa-arrow-circle-left" href="#premium" data-slide="next"></a>
    </div>
    <div class="panel-body">
      <div id="premium" class="carousel slide" data-interval="false">
        <!-- Carousel items -->
        <div class="carousel-inner">
          <?php $count=1; ?>
          @foreach($premiums as $premium)
          @if($count%4 == 1)
          <div class="item {{($count==1)?'active':''}}">
            @endif
            <div class="col-xs-6 col-sm-3">
              <div class="thumbnail">
                <a href="/product/{{$premium->id}}/{{Str::slug($premium->name)}}"><img src="/img-product/{{$premium->imageThumbnail['name']}}" alt="{{$premium->name}}" width="199px"></a>
                <div class="caption">
                  <div class="product-title">
                    <a href="/product/{{$premium->id}}/{{Str::slug($premium->name)}}">{{$premium->subName()}}</a>
                  </div>
                  <div class="product-title">
                    <a href="/store/{{$premium->profile_id}}/{{Str::slug($premium->profile->shop_name)}}" class="shop-name">{{$premium->profile->shop_name}}</a>
                  </div>
                  <div class="product-price center">RM {{$premium->sale_price}}</div>
                </div>
              </div>
            </div>
            @if ($count%4 == 0)</div>@endif
            <?php $count++ ?>
            @endforeach
            @if ($count%4 != 1) </div> @endif
          </div>
        </div>
      </div>
    </div>
  </div>
  <!-- END PREMIUM PRODUCT -->
</div>
@endif <!-- PREMIUM EXIST -->

<!-- FEATURED PRODUCT -->
@if(count($featureds)>0)
<div class="row">
  <div class="col-sm-12 col-xs-12">
    <div class="panel panel-default">
      <div class="panel-heading"><b>Featured Product</b>
        <a class="pull-right fa fa-2x fa-arrow-circle-right" href="#featured" data-slide="prev"></a>
        <span class="pull-right">&nbsp;&nbsp;</span>
        <a class="pull-right fa fa-2x fa-arrow-circle-left" href="#featured" data-slide="next"></a>
      </div>
      <div class="panel-body">

        <div id="featured" class="carousel slide" data-interval="false">
          <!-- Carousel items -->
          <div class="carousel-inner">
            <?php $count=1; ?>
            @foreach($featureds as $featured)
            @if($count%6 == 1)
            <div class="item {{($count==1)?'active':''}}">
              @endif
              <div class="col-xs-6 col-sm-2">
                <div class="thumbnail">
                  <a href="/product/{{$featured->id}}/{{Str::slug($featured->name)}}"><img src="/img-product/{{$featured->imageThumbnail['name']}}" alt="{{$featured->name}}" width="199px" style="min-height:167px;max-height:167px"></a>
                  <div class="caption">
                    <div class="product-title">
                      <a href="/product/{{$featured->id}}/{{Str::slug($featured->name)}}">{{$featured->subName()}}</a>
                    </div>
                    <div class="product-title">
                      <a href="/store/{{$featured->profile_id}}/{{Str::slug($featured->profile->shop_name)}}" class="shop-name">{{$featured->profile->shop_name}}</a>
                    </div>
                    <div class="product-price center">RM {{$featured->sale_price}}</div>
                  </div>
                </div>
              </div>
              @if ($count%6 == 0)</div>@endif
              <?php $count++ ?>
              @endforeach
              @if ($count%6 != 1) </div> @endif
            </div>
          </div>
        </div>
      </div>

      <!-- BANNER B1 -->
      <div class="row visible-md visible-lg" style="padding-bottom:15px">
        <div class="col-sm-6 col-xs-6">
          <div id="bannerB1" class="carousel slide" data-ride="carousel">
            <!-- Wrapper for slides -->
            <div class="carousel-inner">
             <?php $n1=1; ?>
             @foreach($bannerB1s as $bannerB1)
             <a href="{{$bannerB1->link}}" target="_blank" class="item {{($n1==1)?'active':''}}">
              <img src="/img-ad/{{$bannerB1->filename}}" width="100%">
            </a>
            <?php $n1++; ?>
            @endforeach
          </div>
          <!-- Controls -->
          <a class="left carousel-control" href="#bannerB1" data-slide="prev">
            <span class="glyphicon glyphicon-chevron-left"></span>
          </a>
          <a class="right carousel-control" href="#bannerB1" data-slide="next">
            <span class="glyphicon glyphicon-chevron-right"></span>
          </a>
        </div>
        <span class="pull-right visible-lg visible-md" style="font-size:10px">
          <a href="{{(!is_null(Auth::user()))?'/member/advertising/place-ads':'/advertising'}}">Advertise Here</a>
        </span>
      </div>
      <div class="col-sm-6 col-xs-6">
        <div id="bannerB2" class="carousel slide" data-ride="carousel">
          <!-- Wrapper for slides -->
          <div class="carousel-inner">
            <?php $n2=1; ?>
            @foreach($bannerB2s as $bannerB2)
            <a href="{{$bannerB2->link}}" target="_blank" class="item {{($n2==1)?'active':''}}">
              <img src="/img-ad/{{$bannerB2->filename}}" width="100%">
            </a>
            <?php $n2++; ?>
            @endforeach
          </div>
          <!-- Controls -->
          <a class="left carousel-control" href="#bannerB2" data-slide="prev">
            <span class="glyphicon glyphicon-chevron-left"></span>
          </a>
          <a class="right carousel-control" href="#bannerB2" data-slide="next">
            <span class="glyphicon glyphicon-chevron-right"></span>
          </a>
        </div>
        <span class="pull-right visible-lg visible-md" style="font-size:10px">
          <a href="{{(!is_null(Auth::user()))?'/member/advertising/place-ads':'/advertising'}}">Advertise Here</a>
        </span>
      </div>
    </div>
    @endif <!-- FEATURED EXIST -->

    <!-- BEST SELLER -->
    @if(count($best_sellers)>0)
    <div class="row">
      <div class="col-sm-12 col-xs-12">
        <div class="panel panel-default">
          <div class="panel-heading"><b>Best Seller</b>
           <a class="pull-right fa fa-2x fa-arrow-circle-right" href="#best_seller" data-slide="prev"></a>
           <span class="pull-right">&nbsp;&nbsp;</span>
           <a class="pull-right fa fa-2x fa-arrow-circle-left" href="#best_seller" data-slide="next"></a>
         </div>
         <div class="panel-body">
           <div id="best_seller" class="carousel slide" data-interval="false">
            <!-- Carousel items -->
            <div class="carousel-inner">
              <?php $count=1; ?>
              @foreach($best_sellers as $best)
              @if($count%6 == 1)
              <div class="item {{($count==1)?'active':''}}">
                @endif
                <div class="col-xs-6 col-sm-2">
                  <div class="thumbnail">
                    <a href="/product/{{$best->id}}/{{Str::slug($best->name)}}"><img src="/img-product/{{$best->imageThumbnail['name']}}" alt="{{$best->name}}" width="199px" style="min-height:167px;max-height:167px"></a>
                    <div class="caption">
                      <div class="product-title">
                        <a href="/product/{{$best->id}}/{{Str::slug($best->name)}}">{{$best->subName()}}</a>
                      </div>
                      <div class="product-title">
                        <a href="/store/{{$best->profile_id}}/{{Str::slug($best->profile->shop_name)}}" class="shop-name">{{$best->profile->shop_name}}</a>
                      </div>
                      <div class="product-price center">RM {{$best->sale_price}}</div>
                    </div>
                  </div>
                </div>
                @if ($count%6 == 0)</div>@endif
                <?php $count++ ?>
                @endforeach
                @if ($count%6 != 1) </div> @endif
              </div>
            </div>
          </div>
        </div>
        @endif <!-- BEST SELLER EXIST -->

        <!-- NEW PRODUCT -->
        <div class="row">
          <div class="col-sm-12 col-xs-12">
            <div class="panel panel-default">
              <div class="panel-heading"><b>New Product</b></div>
              <div class="panel-body">
                <?php $count=1; ?>
                @foreach($news as $new)
                <div class="col-xs-6 col-sm-2">
                  <div class="thumbnail">
                    <a href="/product/{{$new->id}}/{{Str::slug($new->name)}}"><img class="thumbnailHover" src="/img-product/{{$new->imageThumbnail['name']}}" alt="{{$new->name}}" width="199px" style="min-height:167px;max-height:167px"></a>
                    <div class="caption">
                      <div class="product-title">
                        <a href="/product/{{$new->id}}/{{Str::slug($new->name)}}">{{$new->subName()}}</a>
                      </div>
                      <div class="product-title">
                        <a href="/store/{{$new->profile_id}}/{{Str::slug($new->profile->shop_name)}}" class="shop-name">{{$new->profile->shop_name}}</a>
                      </div>
                      <div class="product-price center">RM {{$new->sale_price}}</div>
                    </div>
                  </div>
                </div>
                @endforeach
              </div>
            </div>
          </div>
        </div>

        @stop