@extends('template')
@section('body')
<h3>{{$category_name->name}}</h3>
<hr>
<div class="row">
  <div class="col-sm-2 visible-sm visible-md visible-lg" style="padding-right:0px">
    <div class="panel panel-default">
      <div class="panel-heading"><b>Refine Search</b></div>
      <div class="panel-body">
        <div style="padding:5px">
          <b>Price Range (RM)</b>
          <form method="post" action="/category">
            <input type="hidden" name="category_id" value="{{$category_name->id}}">
            <input type="number" name="price_min" class="form-control">to
            <input type="number" name="price_max" class="form-control"><br>
            <button type="submit" class="btn btn-sm btn-warning">Search</button>
          </form>
        </div>
      </div>
    </div>
  </div>
  <div class="col-sm-10 col-xs-12">
    <div class="panel panel-default">
      <div class="panel-heading"><b>All Product</b>
        <a class="pull-right fa fa-2x fa-arrow-circle-right" href="#category_product" data-slide="prev"></a>
        <span class="pull-right">&nbsp;&nbsp;</span>
        <a class="pull-right fa fa-2x fa-arrow-circle-left" href="#category_product" data-slide="next"></a>
      </div>
      <div class="panel-body">
        @if(count($category_products)==0)
        <div class="col-sm-2">
          <h5>Product not found.</h5>
        </div>
        @endif
        <div id="category_product" class="carousel slide" data-interval="false">
          <!-- Carousel items -->
          <div class="carousel-inner">
            <?php $count=1; ?>
            @foreach($category_products as $category_product)
            @if($count%24 == 1)
            <div class="item {{($count==1)?'active':''}}">
              @endif
              <div class="col-sm-3 col-xs-6">
                <div class="thumbnail">
                  <a href="/product/{{$category_product->id}}/{{Str::slug($category_product->name)}}"><img src="/img-product/{{$category_product->imageThumbnail['name']}}" alt="{{$category_product->name}}" width="199px"></a>
                  <div class="caption">
                    <div class="product-title">
                      <a href="/product/{{$category_product->id}}/{{Str::slug($category_product->name)}}">{{$category_product->subName()}}</a>
                    </div>
                    <div class="product-title">
                      <a href="/store/{{$category_product->profile_id}}/{{Str::slug($category_product->profile->shop_name)}}" class="shop-name">{{$category_product->profile->shop_name}}</a>
                    </div>
                    <div class="product-price center">RM {{$category_product->sale_price}}</div>
                  </div>
                </div>
              </div>
              @if ($count%24 == 0)</div>@endif
              <?php $count++ ?>
              @endforeach
              @if ($count%24 != 1) </div> @endif
            </div>
          </div>
        </div>
      </div>

      <!-- END PRODUCT -->

    </div>
  </div>
  @stop