@extends('admin/template')
@section('body')

<table class="table table-striped table-bordered dataTable" cellspacing="0" width="100%">
	<thead>
		<tr>
			<th>Category</th>
			<th>Name</th>
			<th class="center">Image</th>
			<th class="center">Shop Name</th>
			<th class="center">Owner Name</th>
			<th class="center">Owner contact</th>
			<th class="center">Type</th>
			<th></th>
		</tr>
	</thead>
	<tbody>
		@foreach($list_products as $list_product)
		<tr>
			<td>{{$list_product->category->name}}</td>
			<td>{{$list_product->name}}</td>
			<td class="center">	
				<img class="large-thumbnail" src="/img-product/{{$list_product->imageThumbnail['name']}}" style="min-width:100px;max-width:100px;min-height:100px;max-height:100px">
			</td>
			<td class="center">{{$list_product->profile->shop_name}}</td>
			<td class="center">{{$list_product->profile->user->name}}</td>
			<td class="center">{{$list_product->profile->handphone}}</td>
			<td class="center">
				@if($list_product->type == '0'){{'New'}}@endif
				@if($list_product->type == '1'){{'Premium'}}@endif
				@if($list_product->type == '2'){{'Featured'}}@endif
			</td>
			<td>
				<p><a href="/admin/premium/{{$list_product->id}}" class="btn btn-xs btn-block {{($list_product->type=='1')?'btn-success':'btn-default'}}">Premium</a></p>
				<p><a href="/admin/featured/{{$list_product->id}}" class="btn btn-xs btn-block {{($list_product->type=='2')?'btn-primary':'btn-default'}}">Featured</a></p>
				<p><a href="/admin/remove-product/{{$list_product->id}}" onclick="return confirm('Product will be remove.')"class="btn btn-xs btn-block btn-danger">Remove</a></p>
			</td>
		</tr>
		@endforeach
	</tbody>
</table>


@stop

@section('status-message')

@if(Session::has('status') && Session::get('status') === true)
<div class="alert msg">
	<button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
	<strong>Action Success</strong>
</div>
@endif
@if(Session::has('status') && !Session::get('status') )
<div class="alert msg">
	<button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
	<strong>ERROR! Try again</strong>
</div>
@endif

@stop