@extends('admin/template')
@section('body')

<table class="table table-striped table-bordered dataTable" cellspacing="0" width="100%">
	<thead>
		<tr>
			<th>Name</th>
			<th class="center">No IC / Passport</th>
			<th>Email</th>
			<th class="center">No HP</th>
			<th>Shop Name</th>
			<th class="center">Status</th>
			<th></th>
		</tr>
	</thead>
	<tbody>
		@foreach($list_members as $list_member)
		<tr>
			<td>{{$list_member->name}}</td>
			<td class="center">{{$list_member->profile->no_ic}}</td>
			<td>{{$list_member->profile->email}}</td>
			<td class="center">{{$list_member->profile->handphone}}</td>
			<td>{{$list_member->profile->shop_name}}</td>
			<td class="center">{{$list_member->type}}</td>
			<td>
				<center>
					<a href="/admin/member-activate/{{$list_member->id}}" class="btn btn-xs btn-success">Activate</a>
					<a href="/admin/member-deactivate/{{$list_member->id}}" onclick="return confirm('Member account will be deactivate.')"class="btn btn-xs btn-danger">Deactivate</a>
				</center>
			</td>
		</tr>
		@endforeach
	</tbody>
</table>


@stop

@section('status-message')

@if(Session::has('status') && Session::get('status') === true)
<div class="alert msg">
	<button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
	<strong>Action Success</strong>
</div>
@endif
@if(Session::has('status') && !Session::get('status') )
<div class="alert msg">
	<button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
	<strong>ERROR! Try again</strong>
</div>
@endif

@stop
