@extends('admin/template')
@section('body')

<div class="col-sm-6">
	<table class="table table-striped table-bordered dataTable" cellspacing="0" width="100%">
		<thead>
			<tr>
				<th>Subject</th>
				<th class="center">Status</th>
				<th></th>
			</tr>
		</thead>
		<tbody>
			@foreach($list_feedbacks as $list_feedback)
			<tr>
				<td>{{$list_feedback->subject}}</td>
				<td class="center">{{$list_feedback->status}}</td>
				<td>
					<center>
						<a href="/admin/feedback/{{$list_feedback->id}}" class="btn btn-xs {{(Request::segment(3)==$list_feedback->id)?'btn-primary':'btn-default'}}">View</a>
						<a href="/admin/feedback-delete/{{$list_feedback->id}}" onclick="return confirm('Feedback will be delete.')"class="btn btn-xs btn-danger">Delete</a>
					</center>
				</td>
			</tr>
			@endforeach
		</tbody>
	</table>
</div>

@if($feedback!=null)
<div class="col-sm-6">
	<form class="form-horizontal" method="post">
		<div class="form-group">
			<label class="col-md-3 control-label">Email</label>
			<div class="col-md-9">{{$feedback->email}}</div>
		</div>
		<div class="form-group">
			<label class="col-md-3 control-label">Subject</label>
			<div class="col-md-9">{{$feedback->subject}}</div>
		</div>
		<div class="form-group">
			<label class="col-md-3 control-label">Message</label>
			<div class="col-md-9">{{$feedback->message}}</div>
		</div>
		<div class="form-group">
			<label class="col-md-3 control-label">Reply</label>
			<div class="col-md-9">
				<input type="hidden" name="email" value="{{$feedback->email}}">
				<input type="text" name="subject" class="form-control" required placeholder="Subject"><p></p>
				<textarea class="summernote" name="message" rows="10"></textarea>
			</div>
		</div>
		<div class="form-group">
			<div class="col-md-offset-3 col-md-9">
				<button type="submit" class="btn btn-warning">Submit</button>
			</div>
		</div>
	</form>
</div>
@endif

@stop

@section('status-message')

@if(Session::has('status') && Session::get('status') === true)
<div class="alert msg">
	<button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
	<strong>Action Success</strong>
</div>
@endif
@if(Session::has('status') && !Session::get('status') )
<div class="alert msg">
	<button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
	<strong>ERROR! Try again</strong>
</div>
@endif

@stop