@extends('admin/template')
@section('body')

<table class="table table-striped table-bordered dataTable" cellspacing="0" width="100%">
	<thead>
		<tr>
			<th>Id</th>
			<th>Name</th>
			<th>Contact</th>
			<th>Email</th>
			<th>Type</th>
			<th class="center">Price</th>
			<th class="center">Period</th>
			<th class="center">Start date</th>
			<th class="center">End date</th>
			<th class="center">Status</th>
			<th></th>
		</tr>
	</thead>
	<tbody>
		@foreach($list_ads as $list_ad)
		<tr>
			<td>{{$list_ad->user_id}}/{{$list_ad->id}}</td>
			<td>{{$list_ad->user->name}}</td>
			<td>{{$list_ad->user->profile->handphone}}</td>
			<td>{{$list_ad->user->profile->email}}</td>
			<td>{{$list_ad->type}}</td>
			<td class="center">{{$list_ad->price}}</td>
			<td class="center">{{$list_ad->period}}</td>
			<td class="center">{{$list_ad->start_date}}</td>
			<td class="center">{{$list_ad->end_date}}</td>
			<td class="center">{{$list_ad->status}}</td>
			<td>
				<center>
					<button data-toggle="modal" data-target="#modal{{$list_ad->id}}" class="btn btn-xs btn-success">Activate</button>
					<a href="/admin/deactivate/{{$list_ad->id}}" onclick="return confirm('Ads will be deactivate.')"class="btn btn-xs btn-danger">Deactivate</a>
					<!-- MODAL ACTIVATE -->
					<div class="modal fade" id="modal{{$list_ad->id}}" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
						<div class="modal-dialog">
							<div class="modal-content">
								<div class="modal-header">
									<button type="button" class="close" data-dismiss="modal"><span aria-hidden="true">&times;</span><span class="sr-only">Close</span></button>
									<h4 class="modal-title" id="myModalLabel">Ads Activation</h4>
								</div>
								<div class="modal-body">
									<form class="form-horizontal" method="post">
										<div class="form-group">
											<label class="col-md-3 control-label">Start Date</label>
											<div class="col-md-8">
												<input type="datetime-local" class="form-control" name="start_date" required>
											</div>
											<div class="col-lg-1"></div>
										</div>
										<div class="form-group">
											<label class="col-md-3 control-label">End Date</label>
											<div class="col-md-8">
												<input type="datetime-local" class="form-control" name="end_date" required>
											</div>
											<div class="col-md-1"></div>
										</div>
										<div class="form-group">
											<label class="col-md-3 control-label">Date format</label>
											<div class="col-md-8 left"><h5>dd-M-yyy hh:mm (AM/PM)</h5></div>
											<div class="col-md-1"></div>
										</div>
										<div class="form-group">
											<div class="col-md-11">
												<input type="hidden" name="ads_id" value="{{$list_ad->id}}">
												<button type="submit" class="btn btn-sm btn-warning pull-right">Save Changes</button>
											</div>
										</div>
									</form>
								</div>
							</div>
						</div>
					</div>
				</center>
			</td>
		</tr>
		@endforeach
	</tbody>
</table>


@stop

@section('status-message')

@if(Session::has('status') && Session::get('status') === true)
<div class="alert msg">
	<button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
	<strong>Action Success</strong>
</div>
@endif
@if(Session::has('status') && !Session::get('status') )
<div class="alert msg">
	<button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
	<strong>ERROR! Try again</strong>
</div>
@endif

@stop
