<?php

class StoreProvider{
	protected $user;
	protected $profile;
	protected $product;
	protected $image;
	protected $category;
	protected $cart;
	protected $order;
	protected $order_details;
	protected $order_status;

	public function __construct(User $user, Profile $profile, Product $product, 
		ImageProduct $image, Category $category, Cart $cart, Order $order, 
		OrderDetails $order_details, OrderStatus $order_status){
		$this->user = $user;
		$this->profile = $profile;
		$this->product = $product;
		$this->image = $image;
		$this->category = $category;
		$this->cart = $cart;
		$this->order = $order;
		$this->order_details = $order_details;
		$this->order_status = $order_status;
	}

	public function getSeller($id){
		return $this->profile->find($id);
	}

	public function getStore($store_id){
		return $this->profile->find($store_id);
	}

	private function uploadShopBanner(){
		$file = Input::file('shop_banner');
		$destinationPath = 'img-banner/';
		if($file){
			$filename = Auth::user()->id.'.'.$file->getClientOriginalExtension();
			try {
				unlink($destinationPath.$filename);
			} catch (Exception $e) {
				
			}
			if($file->move($destinationPath, $filename)){}
				return $filename;				
			return false;
		}
		return false;
	}

	private function uploadShopLogo(){
		$file = Input::file('shop_logo');
		$destinationPath = 'img-logo/';
		if($file){
			$filename = Auth::user()->id.'.'.$file->getClientOriginalExtension();
			try {
				unlink($destinationPath.$filename);
			} catch (Exception $e) {
				
			}
			if($file->move($destinationPath, $filename)){}
				return $filename;				
			return false;
		}
		return false;
	}

	public function updateStoreDetails($input){
		try {
			DB::transaction(function() use ($input){
				$profile = $this->profile->find(Auth::user()->profile_id);	

				//upload banner	
				$banner_filename = $this->uploadShopBanner();
				if($banner_filename){
					$profile->shop_banner = $banner_filename;
				}

				//upload logo	
				$logo_filename = $this->uploadShopLogo();
				if($logo_filename){
					$profile->shop_logo = $logo_filename;
				}
				
				$profile->shop_name = $input['shop_name'];
				$profile->shop_fb = $input['shop_fb'];
				$profile->shop_contact = $input['shop_contact'];
				$profile->shop_address = $input['shop_address'];
				$profile->save();

			});		
		} catch (Exception $e) {
			return false;
		}
		return true;
	}

	public function updateAboutus($input){
		try {
			DB::transaction(function() use ($input){
				$profile = $this->profile->find(Auth::user()->profile_id);
				$profile->shop_aboutus = $input['shop_aboutus'];
				$profile->save();
			});
		}catch (Exception $e) {
			return false;
		}
		return true;
	}

	public function updatePayment($input){
		try {
			DB::transaction(function() use ($input){
				$profile = $this->profile->find(Auth::user()->profile_id);
				$profile->shop_payment = $input['shop_payment'];
				$profile->save();
			});
		}catch (Exception $e) {
			return false;
		}
		return true;
	}

	public function updateDelivery($input){
		try {
			DB::transaction(function() use ($input){
				$profile = $this->profile->find(Auth::user()->profile_id);
				$profile->shop_delivery = $input['shop_delivery'];
				$profile->save();
			});
		}catch (Exception $e) {
			return false;
		}
		return true;
	}

	public function updatePolicy($input){
		try {
			DB::transaction(function() use ($input){
				$profile = $this->profile->find(Auth::user()->profile_id);
				$profile->shop_policy = $input['shop_policy'];
				$profile->save();
			});
		}catch (Exception $e) {
			return false;
		}
		return true;
	}

	public function updateTnc($input){
		try {
			DB::transaction(function() use ($input){
				$profile = $this->profile->find(Auth::user()->profile_id);
				$profile->shop_tnc = $input['shop_tnc'];
				$profile->save();
			});
		}catch (Exception $e) {
			return false;
		}
		return true;
	}

}