<?php

class SocialProvider{
	protected $user;
	protected $profile;
	protected $fbUser;

	public function __construct(User $user, Profile $profile){
		$this->user = $user;
		$this->profile = $profile;

		$application = array(
			'appId' => '1430859960526136',
			'secret' => 'a19175466974b2531151f947c2cb53cd'
			);
		FacebookConnect::getFacebook($application);
	}

	public function loginWithFacebook() {

    // get data from input
		$code = Input::get( 'code' );

    // get fb service
		$fb = OAuth::consumer( 'Facebook' );

    // check if code is valid

    // if code is provided get user data and sign in
		if ( !empty( $code ) ) {

        // This was a callback request from facebook, get the token
			$token = $fb->requestAccessToken( $code );

        // Send a request with it
			$result = json_decode( $fb->request( '/me' ), true );			
			
			//check exist
			$exist = $this->user->where('fb_id','=',$result['id'])->first();
			if(!$exist){
				try {
					$exist = DB::transaction(function() use ($result,$token){
						//dd($token);
						// insert to profile
						$profile = new $this->profile;
						$profile->email = $result['email'];
						$profile->gender = ucfirst($result['gender']);
						$profile->save();

						// insert to users
						$user = new $this->user;
						$user->profile_id = $profile->id;
						$user->name = $result['name'];
						$user->fb_id = $result['id'];
						$user->access_token = $token->getAccessToken();
						$user->type = "member";
						$user->save();

						return $user;
					});
				} catch (Exception $e) {
					return false;
				}
			}

			// update acces token
			else{
				$exist->access_token = $token->getAccessToken();
				$exist->save();
			}
			//login
			Auth::login($exist);
			return true;
		}
    	// if not ask for permission first
		else {
        // get fb authorization
			$url = $fb->getAuthorizationUri();

        // return to facebook login url
			return Redirect::to( (string)$url );
		}

	}

	public function productToWall($product_id,$slug=null){
		try {
			// post to wall facebook.
			$message = array(
				'link'    => 'market.kounimap.com/product/'.$product_id.'/'.$slug,
				'message' => 'New item added to Market Kounimap. Join us now!',
				'access_token' => Auth::user()->access_token
				);

			FacebookConnect::postToFacebook($message, 'feed');

		} catch (Exception $e) {
			dd($e);
		}

	}

}