<?php

class ProductProvider{
	protected $user;
	protected $profile;
	protected $product;
	protected $image;
	protected $category;
	protected $cart;
	protected $order;
	protected $order_details;
	protected $order_status;
	protected $product_best;

	public function __construct(User $user, Profile $profile, Product $product, 
		ImageProduct $image, Category $category, Cart $cart, Order $order, 
		OrderDetails $order_details, OrderStatus $order_status, ProductBest $product_best){
		$this->user = $user;
		$this->profile = $profile;
		$this->product = $product;
		$this->image = $image;
		$this->category = $category;
		$this->cart = $cart;
		$this->order = $order;
		$this->order_details = $order_details;
		$this->order_status = $order_status;
		$this->product_best = $product_best;
	}
	//==================== Index Product ==================
	// product->type = 0
	public function newProductIndex(){
		return $this->product->where('type','=','0')
		->orderBy(DB::raw('RAND()'))->get();
	}

	// product->type = 1
	public function premiumProductIndex(){
		return $this->product->where('type','=','1')
		->orderBy(DB::raw('RAND()'))->get();
	}

	// product->type = 2
	public function featuredProductIndex(){
		return $this->product->where('type','=','2')
		->orderBy(DB::raw('RAND()'))->get();
	}

	public function bestSellerProductIndex(){
		return $this->product_best->take(20)->get();
	}

	//===================== Store Product ==================
	public function newProductStore($store_id){
		return $this->product->where('profile_id','=',$store_id)
		->where('type','!=','2')
		->orderBy(DB::raw('RAND()'))->get();
	}

	public function featuredProductStore($store_id){
		return $this->product->where('profile_id','=',$store_id)
		->where('type','=','2')
		->orderBy(DB::raw('RAND()'))->get();
	}

	public function bestProductStore($store_id){
		return $this->product_best->where('profile_id','=',$store_id)
		->take(20)->get();
	}

	//====================== One Product ======================
	public function getProduct($product_id){
		return $this->product->find($product_id);
	}

	public function getProductCategory($profile_id,$category_id){
		return $this->product->where('profile_id','=',$profile_id)
		->where('category_id','=',$category_id)
		->get();
	}

	public function resetImageSession(){
		if(Session::has('images')){
			$filenames = Session::get('images');
			//delete file
			foreach ($filenames as $filename) {
				try{
					unlink('uploads/'.$filename);
				}catch(Exception $e){

				}
				
			}
		}
		Session::put('images',null);
		Session::put('deleted_images',null);
	}

	public function getProductImage($product_id){
		$product = $this->product->find($product_id);
		$this->resetImageSession();
		foreach ($product->image as $image) {
			Session::push('images', $image->name);
			copy('img-product/'.$image->name, 'uploads/'.$image->name);
		}
	}

	public function allProduct(){
		return Product::where('profile_id','=',Auth::user()->profile_id)->get();
	}

	public function productAdd($input){
		try {
			$product_id['id'] = -1;
			return DB::transaction(function() use ($input,$product_id){
				$product = new $this->product;
				$product->profile_id = Auth::user()->profile_id;
				$product->category_id = $input['category_id'];
				$product->name = $input['name'];
				$product->retail_price = $input['retail_price'];
				$product->sale_price = $input['sale_price'];
				$product->description = $input['description'];
				$product->shipping = $input['shipping'];
				$product->quantity = $input['quantity'];
				$product->save();

				$filenames = Session::get('images');
				foreach ($filenames as $name){
					$image = new $this->image;
					$image->product_id = $product->id;
					$image->name = $name;
					$image->save();
				}
				//move image file
				foreach ($filenames as $filename) {
					rename('uploads/'.$filename, 'img-product/'.$filename);
				}
				//reset session image
				Session::put('images',null);

				return array('product_id'=>$product->id,'product_name'=>Str::slug($product->name));
			});
			//end transaction
		} catch (Exception $e) {
			return -1;
		}
		
	}

	public function productUpdate($input){
		try {
			DB::transaction(function() use ($input){
				$product = $this->product->find($input['product_id']);
				$product->category_id = $input['category_id'];
				$product->name = $input['name'];
				$product->retail_price = $input['retail_price'];
				$product->sale_price = $input['sale_price'];
				$product->description = $input['description'];
				$product->shipping = $input['shipping'];
				$product->quantity = $input['quantity'];
				$product->save();

				// save new image
				$filenames = Session::get('images');
				foreach ($filenames as $name) {
					$sameImage = $this->image->where('name','=',$name)->get();
					if(count($sameImage)==0){
						$image = new $this->image;
						$image->product_id = $product->id;
						$image->name = $name;
						$image->save();
					}
				}

				// delete image from Session::get('deleted_images')
				if(Session::has('deleted_images')){
					$deleted_filenames = Session::get('deleted_images');
					$arrayTemp = array();
					foreach($deleted_filenames as $fn){
						$arrayTemp[] = "'".$fn."'";
					}
					$temp = "(". implode(',', $arrayTemp).")";
					
					DB::table('image_product')			
					->whereRaw('name in '.$temp)
					->update(array('deleted_at'=>date('Y-m-d H:i:s')));
					//dd(DB::getQueryLog());
					Session::put('deleted_images',null);
				}
				//move image file
				foreach ($filenames as $filename){
					rename('uploads/'.$filename, 'img-product/'.$filename);
				}
				//reset session image
				Session::put('images',null);
			});
} catch (Exception $e) {
	return false;
}
return true;
}

public function productDelete($product_id){
	try {
		DB::transaction(function() use ($product_id){
			$product = $this->product->find($product_id);
			$product->delete();

			// delete image
			$images = $this->image->where('product_id','=',$product_id)->get();
			foreach ($images as $image) {
				unlink('img-product/'.$image->name);
				$image->delete();
			}
		});

	} catch (Exception $e) {
		return false;
	}
	return true;
}

}