<?php

class MemberProvider{
	protected $user;
	protected $profile;
	protected $product;
	protected $image;
	protected $category;
	protected $cart;
	protected $order;
	protected $order_details;
	protected $order_status;

	public function __construct(User $user, Profile $profile, Product $product, 
		ImageProduct $image, Category $category, Cart $cart, Order $order, 
		OrderDetails $order_details, OrderStatus $order_status){
		$this->user = $user;
		$this->profile = $profile;
		$this->product = $product;
		$this->image = $image;
		$this->category = $category;
		$this->cart = $cart;
		$this->order = $order;
		$this->order_details = $order_details;
		$this->order_status = $order_status;
	}

	public function login($input){
		Auth::logout();
		$user = array('username' => Input::get('userid'),'password' => Input::get('password'));
		if(Auth::attempt($user)){
			$checkMember = Auth::user();
			return ($checkMember->type=='member')?true:false;
		}
		return false;
	}

	public function personalUpdate($input){
		try {
			DB::transaction(function() use ($input){
				$user = $this->user->find(Auth::user()->id);
				$user->name = $input['name'];
				$user->username = (!isset($input['username'])||$input['username']=='')?$user->username:$input['username'];
				$user->password = (!isset($input['password'])||$input['password']=='')?$user->password:Hash::make($input['password']);
				$user->save();

				$profile = $this->profile->find(Auth::user()->profile_id);
				$profile->no_ic = $input['no_ic'];
				$profile->gender = $input['gender'];
				$profile->birthdate = $input['birthdate'];
				$profile->address = $input['address'];
				$profile->homephone = ($input['homephone']=='')?'':$input['homephone'];
				$profile->officephone = ($input['officephone']=='')?'':$input['officephone'];
				$profile->handphone = $input['handphone'];
				$profile->email = $input['email'];
				$profile->save();
			});
		} catch (Exception $e) {
			return false;
		}
		return true;
	}

	public function listCart(){
		return Auth::user()->cart->groupBy('profile_id');
	}

	public function listProductInvoice($input){
		$cart = array();
		foreach ($input as $key => $value) {
			$id = explode('-', $key);
			$cart_id = $id[1];

			$cart[] = Auth::user()->cart->find($cart_id);
		}
		return $cart;
	}

	public function checkout($input){
		try {
			foreach ($input as $key => $value) {
				$id = explode('-', $key);
				$cart_id = $id[1];

				DB::transaction(function() use ($cart_id,$value){
					$cart = $this->cart->find($cart_id);
					$cart->quantity = $value;
					$cart->save();
				});
			}
		} catch (Exception $e) {
			return false;
		}
		return true;
	}

	public function confirmOrder($input){
		try {
			DB::transaction(function() use ($input){

				$cart = $this->cart->find($input['cart_id'][0]);
				$order = new $this->order;
				$order->user_id = $cart->user_id;
				$order->profile_id = $cart->profile_id;
				$order->save();

				foreach ($input['cart_id'] as $cart_id) {
					$cart = $this->cart->find($cart_id);

					$order_details = new $this->order_details;
					$order_details->order_id = $order->id;
					$order_details->product_id = $cart->product_id;
					$order_details->unit_price = $cart->product->sale_price;
					$order_details->quantity = $cart->quantity;
					$order_details->save();

					$cart->delete();
				}
				$order_status = new $this->order_status;
				$order_status->order_id = $order->id;
				$order_status->status = "Pending";
				$order_status->save();

				$order->latest_statusID = $order_status->id;
				$order->save();
			});
		} catch (Exception $e) {
			return false;
		}
		return true;
	}

	public function orderList($status){
		return DB::table('order')			
		->join('order_status','order_status.id','=','order.latest_statusID')
		//->join('order_details','order_details.order_id','=','order.id')
		->where('order.user_id','=',Auth::user()->id)
		->where('order_status.status','like',$status)
		->get();
	}

	public function allOrderList(){
		return DB::table('order')
		->select('order.id','order.profile_id','order.user_id','order_status.tarikh','order_status.status','users.name')			
		->join('order_status','order_status.id','=','order.latest_statusID')
		->join('users','users.id','=','order.user_id')
		->where('order.profile_id','=',Auth::user()->profile_id)
		->get();
	}

	public function orderDetail($order_id){
		return $this->order->find($order_id);
	}

	public function getOrderStatus($status_id){
		return $this->order_status->find($status_id);
	}

	public function uploadPaymentSlip($input){
		try {
			$file = Input::file('payment_image');
			$filename = Auth::user()->id.'-'.$input['order_id'].'-'.$file->getClientOriginalName();
			$destinationPath = 'img-payment/';

			if($file->move($destinationPath, $filename)){
				DB::transaction(function() use ($input,$filename){
					$order_status = new $this->order_status;
					$order_status->order_id = $input['order_id'];
					$order_status->status = "Paid";
					$order_status->payment_image = $filename;
					$order_status->save();

					$order = $this->order->find($input['order_id']);
					$order->latest_statusID = $order_status->id;
					$order->save();
				});		
			}
		} catch (Exception $e) {
			return false;
		}
		return true;
	}

	public function slipValidate($order_id){
		try {
			DB::transaction(function() use ($order_id){
				$order_status = new $this->order_status;
				$order_status->order_id = $order_id;
				$order_status->status = "Delivery";
				$order_status->description = "In delivery process.";
				$order_status->save();

				$order = $this->order->find($order_id);
				$order->latest_statusID = $order_status->id;
				$order->save();
			});		
		} catch (Exception $e) {
			return false;
		}
		return true;
	}

	public function sellApprove($input){
		try {
			DB::transaction(function() use ($input){
				$order_status = new $this->order_status;
				$order_status->order_id = $input['order_id'];
				$order_status->status = "Approved";
				$order_status->description = $input['description'];
				$order_status->save();

				$order_details = $this->order_details->where('order_id','=',$input['order_id'])->first();
				$order_details->delivery_charge = $input['delivery_charge'];
				$order_details->save();

				$order = $this->order->find($input['order_id']);
				$order->latest_statusID = $order_status->id;
				$order->save();
			});
		} catch (Exception $e) {
			dd($e);
			return false;
		}
		return true;
	}

	public function sellReject($input){
		try {
			DB::transaction(function() use ($input){

				$order_status = new $this->order_status;
				$order_status->order_id = $input['order_id'];
				$order_status->status = "Rejected";
				$order_status->description = $input['description'];
				$order_status->save();

				$order = $this->order->find($input['order_id']);
				$order->latest_statusID = $order_status->id;
				$order->save();
			});
		} catch (Exception $e) {
			return false;
		}
		return true;
	}


	public function updateDeliveryStatus($input){
		try {
			DB::transaction(function() use ($input){
				$order_status = $this->order_status->find($input['orderStatus_id']);
				$order_status->description = $input['description'];
				$order_status->save();
			});
		} catch (Exception $e) {
			return false;
		}
		return true;
	}

	public function orderReceived($input){
		try {
			DB::transaction(function() use ($input){
				$order_status = new $this->order_status;
				$order_status->order_id = $input['order_id'];
				$order_status->status = "Received";
				$order_status->save();

				$order = $this->order->find($input['order_id']);
				$order->rating_product =$input['rating_product'];
				$order->rating_store = $input['rating_store'];
				$order->feedback = $input['feedback'];
				$order->latest_statusID = $order_status->id;
				$order->save();
			});		
		} catch (Exception $e) {
			return false;
		}
		return true;
	}

	public function changeMemberPassword($input){
		try {
			if(!Hash::check($input['old_password'],Auth::user()->password)){
				return false;
			}

			DB::transaction(function() use ($input){
				$user = $this->user->find(Auth::user()->id);
				$user->password = Hash::make($input['new_password1']);
				$user->save();
			});		
		} catch (Exception $e) {
			return false;
		}
		return true;
	}

}