<?php

class HomeProvider{
	protected $user;
	protected $profile;
	protected $product;
	protected $image;
	protected $category;
	protected $cart;
	protected $order;
	protected $order_details;
	protected $order_status;
	protected $feedback;

	public function __construct(User $user, Profile $profile, Product $product, 
		ImageProduct $image, Category $category, Cart $cart, Order $order, 
		OrderDetails $order_details, OrderStatus $order_status, Feedback $feedback){
		$this->user = $user;
		$this->profile = $profile;
		$this->product = $product;
		$this->image = $image;
		$this->category = $category;
		$this->cart = $cart;
		$this->order = $order;
		$this->order_details = $order_details;
		$this->order_status = $order_status;
		$this->feedback = $feedback;
	}

	public function storeUrl(){
		if(is_null(Auth::user())){
			Session::put('redirect', URL::full());
		}
	}

	public function forgot($input){
		try {
			$profile = $this->profile->where('email','=',$input['email'])->first();
			if(is_null($profile)){return 'email';}

			DB::transaction(function() use ($input, $profile){
				$user = $this->user->where('profile_id','=',$profile->id)->first();
				if($input['type']=='userid'){
					$data = array(
						'name' => $user->username,
						'password' => '******',
						'pada' => date('d-M-Y'),
						'attention' => ''
						);

					Mail::queue('emails.reset', $data, function($message) use ($user){
						$message->to($user->profile->email, 'Market Kounimap Member')->subject('Your User ID');
					});
				}

				else{
					$newPass = strtoupper(substr(md5(time()),0,8));
					$user->password = Hash::make($newPass);	
					$user->save();

					$data = array(
						'name' => '******',
						'password' => $newPass,
						'pada' => date('d-M-Y'),
						'attention' => '*Please change your password immediately'
						);

					Mail::queue('emails.reset', $data, function($message) use ($user){
						$message->to($user->profile->email, 'Market Kounimap Member')->subject('Your New Password');
					});
				}
			});
		} catch (Exception $e) {
			dd($e);
			return 'error';
		}
		return true;
	}

	public function checkAvailability($username){
		$exist = User::where('username','=',$username)->first();
		if($exist) return "1";
		return "0";
	}

	public function search($input){
		return $this->product->where('name','LIKE','%'.$input['search'].'%')
		->orderBy(DB::raw('RAND()'))->get();
	}
	public function searchStore($input,$store_id){
		return $this->product
		->where('profile_id','=',$store_id)
		->where('name','LIKE','%'.$input['search'].'%')
		->orderBy(DB::raw('RAND()'))->get();
	}

	public function searchPrice($input){
		$price_min = ($input['price_min']=='')?0:$input['price_min'];
		$price_max = ($input['price_max']=='')?99999999:$input['price_max'];
		return $this->product->where('name','LIKE','%'.$input['product_name'].'%')
		->where('sale_price','>=',DB::raw($price_min))
		->where('sale_price','<=',DB::raw($price_max))
		->orderBy('sale_price','asc')->get();
	}

	public function getStoreCategory($store_id){
		return DB::table('product')->select('category.name','product.category_id',DB::raw('count(product.id) as countProduct'))			
		->join('category','category.id','=','product.category_id')
		->where('product.profile_id','=',$store_id)
		->groupBy('product.category_id')
		->orderBy('countProduct','desc')
		->get();
	}

	public function categoryProduct($category_id){
		return $this->product->where('category_id','=',$category_id)->get();
	}

	public function categoryProductSearchPrice($input){
		$price_min = ($input['price_min']=='')?0:$input['price_min'];
		$price_max = ($input['price_max']=='')?99999999:$input['price_max'];
		return $this->product->where('category_id','=',$input['category_id'])
		->where('sale_price','>=',DB::raw($price_min))
		->where('sale_price','<=',DB::raw($price_max))
		->orderBy('sale_price','asc')->get();
	}

	public function categoryName($category_id){
		return $this->category->find($category_id);
	}

	public function buy($input){ // add to cart
		try {
			//find existing item
			$checkExist = $this->cart
			->where('user_id','=',Auth::user()->id)
			->where('product_id','=',$input['product_id'])->first();

			if($checkExist){
				// update item quantity
				DB::transaction(function() use ($input,$checkExist){
					$cart = $this->cart->find($checkExist->id);
					$qtty = $cart->quantity + $input['quantity'];
					$cart->quantity = $qtty;
					$cart->save();
				});
				return true;
			}

			// store into cart table
			DB::transaction(function() use ($input){
				$cart = new $this->cart;
				$cart->user_id = Auth::user()->id;
				$cart->profile_id = $input['profile_id'];
				$cart->product_id = $input['product_id'];
				$cart->quantity = $input['quantity'];
				$cart->save();
			});
		} catch (Exception $e) {
			return false;
		}
		return true;
	}

	public function register($input){
		try {
			DB::transaction(function() use ($input){
				// insert to profile
				$profile = new $this->profile;
				$profile->email = $input['email'];
				$profile->handphone = $input['handphone'];
				$profile->gender = $input['gender'];
				$profile->birthdate = $input['birthdate'];
				$profile->save();

				// insert to users
				$user = new $this->user;
				$user->profile_id = $profile->id;
				$user->username = $input['username'];
				$user->password = Hash::make($input['password']);
				$user->name = $input['name'];
				$user->type = "member";
				$user->save();
			});
		} catch (Exception $e) {
			return false;
		}
		return true;
	}

	public function feedback($input){
		try {
			if($input['address']!='http://')
				return false;

			DB::transaction(function() use ($input){
				$feedback = new $this->feedback;
				$feedback->email = $input['email'];
				$feedback->subject = $input['subject'];
				$feedback->message = $input['message'];
				$feedback->save();
			});
		} catch (Exception $e) {
			return false;
		}
		return true;
	}

}