<?php

class AdsProvider{
	protected $ads;

	public function __construct(Ads $ads){
		$this->ads = $ads;
	}

	public function getAds($type){
		return $this->ads->where('type','=',$type)
		->where('status','=','active')
		->orderBy(DB::raw('RAND()'))->get();
	}

	public function listAds(){
		return $this->ads->groupBy('type')->get();
	}

	public function listAdsMember(){
		return $this->ads->where('user_id','=',Auth::user()->id)->get();
	}

	public function listAdsMemberAdmin(){
		return $this->ads->all();
	}

	public function requestAds($input){
		try {
			$file =  Input::file('image');
			$destinationPath = 'img-ad/';
			$filename = Auth::user()->id.'-'.time().'-'.$file->getClientOriginalName();
			$file->move($destinationPath, $filename);		

			DB::transaction(function() use ($input,$filename){
				$ads = new $this->ads;
				$ads->user_id = Auth::user()->id;
				$ads->type = $input['type'];
				$ads->link = $input['link'];
				$ads->filename = $filename;
				$ads->period = $input['period'];
				$ads->save();
			});
		} catch (Exception $e) {
			return false;
		}
		return true;
	}

	public function adsActivation($input){
		try {
			DB::transaction(function() use ($input){
				$ads = $this->ads->find($input['ads_id']);
				$ads->start_date = $input['start_date'];
				$ads->end_date = $input['end_date'];
				$ads->status = 'active';
				$ads->save();
			});
		} catch (Exception $e) {
			return false;
		}
		return true;
	}

	public function adsDeactivation($ads_id){
		try {
			DB::transaction(function() use ($ads_id){
				$ads = $this->ads->find($ads_id);
				$ads->status = 'deactive';
				$ads->save();
			});
		} catch (Exception $e) {
			return false;
		}
		return true;
	}

}