<?php

class AdminProvider{
	protected $ads;
	protected $user;
	protected $product;
	protected $feedback;

	public function __construct(Ads $ads, User $user, Product $product, Feedback $feedback){
		$this->ads = $ads;
		$this->user = $user;
		$this->product = $product;
		$this->feedback = $feedback;
	}

	public function login($input){
		Auth::logout();
		$user = array('username' => Input::get('username'),'password' => Input::get('password'));
		
		if(Auth::attempt($user)){
			$checkAdmin = Auth::user();
			return ($checkAdmin->type=='admin')?true:false;
		}
		return false;
	}

	public function listProduct(){
		return $this->product->all();
	}

	public function listMember(){
		return $this->user->where('type','<>','admin')->get();
	}

	public function listFeedback(){
		return $this->feedback->all();
	}

	public function feedbackDetail($feedback_id){
		return $this->feedback->find($feedback_id);
	}

	public function replyFeedback($feedback_id,$input){
		try {
			// send email
			$data = array(
				'msg' => $input['message']
				);

			Mail::queue('emails.feedback', $data, function($message) use ($input){
				$message->to($input['email'], 'Market Kounimap')->subject($input['subject']);
			});

			// change status
			DB::transaction(function() use ($feedback_id){
				$feedback = $this->feedback->find($feedback_id);
				$feedback->status = 'Replied';
				$feedback->save();
			});
		} catch (Exception $e) {
			dd($e);
			return false;
		}
		return true;
	}

	public function deleteFeedback($feedback_id){
		try {
			DB::transaction(function() use ($feedback_id){
				$feedback = $this->feedback->find($feedback_id);
				$feedback->delete();
			});
		} catch (Exception $e) {
			return false;
		}
		return true;
	}

	public function memberActivation($user_id){
		try {
			DB::transaction(function() use ($user_id){
				$user = $this->user->find($user_id);
				$user->type = 'member';
				$user->save();
			});
		} catch (Exception $e) {
			return false;
		}
		return true;
	}

	public function memberDeactivation($user_id){
		try {
			DB::transaction(function() use ($user_id){
				$user = $this->user->find($user_id);
				$user->type = 'deactivated';
				$user->save();
			});
		} catch (Exception $e) {
			return false;
		}
		return true;
	}

	public function removeProduct($product_id){
		try {
			DB::transaction(function() use ($product_id){
				$product = $this->product->find($product_id);
				$product->delete();
			});
		} catch (Exception $e) {
			return false;
		}
		return true;
	}

	public function setPremiumProduct($product_id){
		try {
			DB::transaction(function() use ($product_id){
				$product = $this->product->find($product_id);

				if($product->type==1){
					$product->type = '0';
					$product->save();
				}
				else{
					$product->type = '1';
					$product->save();
				}
				
			});
		} catch (Exception $e) {
			return false;
		}
		return true;
	}

	public function setFeaturedProduct($product_id){
		try {
			DB::transaction(function() use ($product_id){
				$product = $this->product->find($product_id);

				if($product->type==2){
					$product->type = '0';
					$product->save();
				}
				else{
					$product->type = '2';
					$product->save();
				}
			});
		} catch (Exception $e) {
			return false;
		}
		return true;
	}

}