<?php

use Illuminate\Auth\UserInterface;
use Illuminate\Auth\Reminders\RemindableInterface;

class User extends Eloquent implements UserInterface, RemindableInterface {

	/**
	 * The database table used by the model.
	 *
	 * @var string
	 */
	protected $table = 'users';

	/**
	 * The attributes excluded from the model's JSON form.
	 *
	 * @var array
	 */
	protected $hidden = array('password');

	/**
	 * Get the unique identifier for the user.
	 *
	 * @return mixed
	 */
	public function getAuthIdentifier()
	{
		return $this->getKey();
	}

	/**
	 * Get the password for the user.
	 *
	 * @return string
	 */
	public function getAuthPassword()
	{
		return $this->password;
	}

	/**
	 * Get the token value for the "remember me" session.
	 *
	 * @return string
	 */
	public function getRememberToken()
	{
		return $this->remember_token;
	}

	/**
	 * Set the token value for the "remember me" session.
	 *
	 * @param  string  $value
	 * @return void
	 */
	public function setRememberToken($value)
	{
		$this->remember_token = $value;
	}

	/**
	 * Get the column name for the "remember me" token.
	 *
	 * @return string
	 */
	public function getRememberTokenName()
	{
		return 'remember_token';
	}

	/**
	 * Get the e-mail address where password reminders are sent.
	 *
	 * @return string
	 */
	public function getReminderEmail()
	{
		return $this->email;
	}

	// ============== added function ======================================
	public function isAdmin(){
		return $this->attributes['admin']=='1' ? true : false;
	}

	public function profile(){
		return $this->belongsTo('Profile');
	}	

	public function cart(){
		return $this->hasMany('Cart');
	}	

	public function order(){
		return $this->hasMany('Order');
	}	

	public function ads(){
		return $this->hasMany('Ads');
	}	

	public function cartBil(){
		return $this->cart()->count();
	}		

	//count BUY order status
	public function countBuyOrderStatus($status='Pending'){
		$count = DB::table('order')			
		->join('order_status','order_status.id','=','order.latest_statusID')
		->where('order.user_id','=',$this->id)
		->where('order_status.status','=',$status)
		->count();

		return $count;
	}	

	//count SELL order status
	public function countSellOrderStatus($status='Pending'){
		$count = DB::table('order')			
		->join('order_status','order_status.id','=','order.latest_statusID')
		->where('order.profile_id','=',$this->profile_id)
		->where('order_status.status','=',$status)
		->count();

		return $count;
	}	

	public function countBuyOrderStatusTotal(){
		return $this->countBuyOrderStatus('Pending') + $this->countBuyOrderStatus('Approved');
	}	

	public function countSellOrderStatusTotal(){
		return $this->countSellOrderStatus('Pending') + $this->countSellOrderStatus('Paid');
	}	


}
