<?php
class Product extends Eloquent  {

	protected $table = 'product';
	protected $softDelete = true;

	public function image(){
		return $this->hasMany('ImageProduct');
	}	

	public function imageThumbnail(){
		return $this->hasOne('ImageProduct')->orderBy('id','asc');
	}	

	public function subName(){
		return substr($this->name,0,15).'..';
	}	

	public function profile(){
		return $this->belongsTo('Profile');
	}

	public function category(){
		return $this->belongsTo('Category');
	}

	public function cart(){
		return $this->belongsTo('Cart');
	}

	public function orderDetails(){
		return $this->hasMany('OrderDetails');
	}

	public function productBest(){
		return $this->hasOne('ProductBest');
	}	

}