<?php
class Order extends Eloquent  {

	protected $table = 'order';
	protected $softDelete = true;

	public function user(){
		return $this->belongsTo('User');
	}

	public function profile(){
		return $this->belongsTo('Profile');
	}	

	public function orderStatus(){
		return $this->hasMany('OrderStatus');
	}

	public function orderDetails(){
		return $this->hasMany('OrderDetails');
	}

	public function latestStatus(){
		return $this->hasOne('Orderstatus')->where('id','=',$this->latest_statusID);
	}

	public function findStatus($status = 'Pending'){
		return $this->orderStatus
		->where('id','=',$this->latest_statusID)
		->where('status','=',$status)
		->get();
	}	


}