<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateTableAds extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{
		Schema::create('ads', function($table)
		{
			$table->increments('id');
			$table->integer('user_id')->unsigned();
			$table->string('type');	
			$table->string('link');
			$table->string('filename');	
			$table->string('price');
			$table->string('status')->default('requesting');
			$table->string('period');
			$table->datetime('start_date');	
			$table->datetime('end_date');	

			$table->date('updated_at');
			$table->date('created_at');
			$table->softDeletes();
		});
	}

	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
		Schema::drop('ads');
	}

}