<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateOrderStatusTable extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{
		Schema::create('order_status', function($table)
		{
			$table->increments('id');
			$table->integer('order_id')->unsigned();
			$table->datetime('tarikh')->default(DB::raw('CURRENT_TIMESTAMP'));
			$table->string('status');
			$table->string('description');
			$table->string('payment_image');

			$table->date('updated_at');
			$table->date('created_at');
			$table->softDeletes();
		});
	}

	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
		Schema::drop('order_status');
	}

}