<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateOrderTable extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{
		Schema::create('order', function($table)
		{
			$table->increments('id');
			$table->integer('user_id')->unsigned();
			$table->integer('profile_id')->unsigned();	
			$table->integer('latest_statusID')->unsigned();	
			$table->string('feedback');
			$table->string('rating_product');
			$table->string('rating_store');

			$table->date('updated_at');
			$table->date('created_at');
			$table->softDeletes();
		});
	}

	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
		Schema::drop('order');
	}

}