<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateProductTable extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{
		Schema::create('product', function($table)
		{
			$table->increments('id');
			$table->integer('profile_id')->unsigned();
			$table->integer('category_id')->unsigned();

			$table->string('name');
			$table->string('retail_price');
			$table->string('sale_price');
			$table->string('description');
			$table->string('shipping');
			$table->integer('quantity');
			$table->integer('type')->unsigned()->default(0);

			$table->date('updated_at');
			$table->date('created_at');
			$table->softDeletes();
		});
	}

	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
		Schema::drop('product');
	}

}