<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreatePofileTable extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{
		Schema::create('profile', function($table)
		{
			$table->increments('id');
			
			// member profile
			$table->string('no_ic');
			$table->string('email');
			$table->string('handphone');
			$table->string('homephone')->nullable();
			$table->string('officephone')->nullable();
			$table->string('address')->nullable();
			$table->string('gender')->nullable();
			$table->date('birthdate');

			// shop profile
			$table->string('shop_name');
			$table->string('shop_banner');
			$table->string('shop_fb');
			$table->string('shop_logo');
			$table->string('shop_address');
			$table->string('shop_contact');
			$table->text('shop_delivery');
			$table->text('shop_payment');
			$table->text('shop_aboutus');
			$table->text('shop_policy');
			$table->text('shop_tnc');

			$table->date('updated_at');
			$table->date('created_at');
			$table->softDeletes();
		});
	}

	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
		Schema::drop('profile');
	}

}