<?php

class SellController extends MemberController {

	public function getProductList(){
		$product = $this->productProvider->allProduct();
		return $this->tempCategory('/member/sell/productList')
		->with('products',$product);
	}

	public function getProductAdd(){
		$this->productProvider->resetImageSession();
		return $this->tempCategory('/member/sell/productAdd');
	}

	public function getOrder(){
		$order_list = $this->memberProvider->allOrderList();
		return $this->tempCategory('/member/sell/order')
		->with('order_lists',$order_list);
	}

	public function getProductUpdate($product_id){
		$product = $this->productProvider->getProduct($product_id);
		$this->productProvider->getProductImage($product_id);
		$product_image = Session::get('images');
		return $this->tempCategory('/member/sell/productUpdate')
		->with('product',$product)
		->with('product_images',$product_image);
	}

	public function getProductDelete($product_id){
		$status = $this->productProvider->productDelete($product_id);
		return Redirect::back()
		->with('status',$status);
	}

	public function getOrderDetails($order_id){
		$orderDetail = $this->memberProvider->orderDetail($order_id);
		return $this->tempCategory('/member/sell/orderDetails')
		->with('orderDetail',$orderDetail);
	}

	public function getPending($order_id){
		$orderDetail = $this->memberProvider->orderDetail($order_id);
		return $this->tempCategory('/member/sell/pending')
		->with('orderDetail',$orderDetail);
	}

	public function getApproved($order_id){
		$orderDetail = $this->memberProvider->orderDetail($order_id);
		return $this->tempCategory('/member/sell/approved')
		->with('orderDetail',$orderDetail);
	}

	public function getPaid($order_id){
		$orderDetail = $this->memberProvider->orderDetail($order_id);
		return $this->tempCategory('/member/sell/paid')
		->with('orderDetail',$orderDetail);
	}

	public function getDelivery($order_id){
		$orderDetail = $this->memberProvider->orderDetail($order_id);
		return $this->tempCategory('/member/sell/delivery')
		->with('orderDetail',$orderDetail);
	}

	public function getRejected($order_id){
		$orderDetail = $this->memberProvider->orderDetail($order_id);
		return $this->tempCategory('/member/sell/rejected')
		->with('orderDetail',$orderDetail);
	}

	public function getReceived($order_id){
		$orderDetail = $this->memberProvider->orderDetail($order_id);
		return $this->tempCategory('/member/sell/received')
		->with('orderDetail',$orderDetail);
	}

	public function getValidate($order_id){
		$status = $this->memberProvider->slipValidate($order_id);
		return Redirect::to('/member/sell/order')
		->with('status',$status);
	}

	public function postUpdateDeliveryStatus(){
		$status = $this->memberProvider->updateDeliveryStatus(Input::all());
		return Redirect::back()
		->with('status',$status);
	}

	public function postProductAdd(){
		$status = $this->productProvider->productAdd(Input::all());		
		// post to FB page wall
		if($status['product_id'] > 0 && Input::get('postFB')){
			$this->socialProvider->productToWall($status['product_id'],$status['product_name']);
		}
		return Redirect::back()
		->with('status',$status>0?true:false);
	}

	public function postProductUpdate(){
		$status = $this->productProvider->productUpdate(Input::all());
		return Redirect::back()
		->with('status',$status);
	}

	public function postApprove(){
		$status = $this->memberProvider->sellApprove(Input::all());
		return Redirect::back()
		->with('status',$status);
	}

	public function postReject(){
		$status = $this->memberProvider->sellReject(Input::all());
		return Redirect::back()
		->with('status',$status);
	}

}