<?php

class MemberController extends BaseController {

	protected $memberProvider;
	protected $productProvider;
	protected $storeProvider;
	protected $categoryProvider;
	protected $adsProvider;
	protected $socialProvider;

	public function __construct(MemberProvider $member, ProductProvider $product, 
		StoreProvider $store, CategoryProvider $category, AdsProvider $ads, SocialProvider $social){
		$this->memberProvider = $member;
		$this->productProvider = $product;
		$this->storeProvider = $store;
		$this->categoryProvider = $category;
		$this->adsProvider = $ads;
		$this->socialProvider = $social;
	}

	public function getIndex(){
		return $this->tempCategory('/member/index');
	}

	public function getChangePassword(){
		return $this->tempCategory('/member/account/changePassword');
	}

	public function postChangePassword(){
		$status = $this->memberProvider->changeMemberPassword(Input::all());
		return Redirect::back()
		->with('status',$status);
	}

}
