<?php

class BuyController extends MemberController {

	public function getCart(){
		if(is_null(Auth::user())){
			Session::put('redirect', URL::full());
		}
		$seller = $this->memberProvider->listCart();
		return $this->tempCategory('/member/buy/cart')
		->with('sellers',$seller);
	}

	public function postCart(){
		$cart = $this->memberProvider->listCart();
		return $this->tempCategory('/member/buy/cart')
		->with('carts',$cart);
	}

	public function getCheckout(){
		try {
			extract(Session::get('sessionCart'));
		} catch (Exception $e) {
			return Redirect::to('/member');
		}
		return $this->tempCategory('/member/buy/checkout')
		->with('status',$status)
		->with('company',$company)
		->with('carts',$cart);
	}

	public function postCheckout($profile_id){
		$status = $this->memberProvider->checkout(Input::all());
		$company = $this->storeProvider->getSeller($profile_id);
		$cart = $this->memberProvider->listProductInvoice(Input::all());
		$sessionCart = array('status'=>$status,'company'=>$company,'cart'=>$cart);
		Session::put('sessionCart',$sessionCart);
		return Redirect::to('/member/buy/checkout');
	}

	public function getConfirmOrder(){
		$statusOrder = false;
		try {
			$statusOrder = Session::get('statusOrder');
		} catch (Exception $e) {
			return Redirect::to('/member');
		}
		return $this->tempCategory('/member/buy/confirm')
		->with('statusOrder',$statusOrder);
	}

	public function postConfirmOrder(){
		$status = $this->memberProvider->confirmOrder(Input::all());
		Session::put('statusOrder',$status);
		return Redirect::to('/member/buy/confirm-order');
	}

	public function getOrder($status='pending'){
		$orderList = $this->memberProvider->orderList($status);
		return $this->tempCategory('/member/buy/order')
		->with('orderLists',$orderList)
		->with('orderStatus',$status);
	}

	public function getPending($order_id){
		$orderList = $this->memberProvider->orderList("Pending");
		$orderDetail = $this->memberProvider->orderDetail($order_id);

		return $this->tempCategory('/member/buy/pending')
		->with('orderLists',$orderList)
		->with('orderDetail',$orderDetail)
		->with('orderStatus','pending');
	}

	public function getApproved($order_id){
		$orderList = $this->memberProvider->orderList("Approved");
		$orderDetail = $this->memberProvider->orderDetail($order_id);

		return $this->tempCategory('/member/buy/approved')
		->with('orderLists',$orderList)
		->with('orderDetail',$orderDetail)
		->with('orderStatus','approved');
	}

	public function getPaid($order_id){
		$orderList = $this->memberProvider->orderList("Paid");
		$orderDetail = $this->memberProvider->orderDetail($order_id);

		return $this->tempCategory('/member/buy/paid')
		->with('orderLists',$orderList)
		->with('orderDetail',$orderDetail)
		->with('orderStatus','paid');
	}

	public function getDelivery($order_id){
		$orderList = $this->memberProvider->orderList("Delivery");
		$orderDetail = $this->memberProvider->orderDetail($order_id);

		return $this->tempCategory('/member/buy/delivery')
		->with('orderLists',$orderList)
		->with('orderDetail',$orderDetail)
		->with('orderStatus','delivery');
	}

	public function getReceived($order_id){
		$orderList = $this->memberProvider->orderList("Received");
		$orderDetail = $this->memberProvider->orderDetail($order_id);

		return $this->tempCategory('/member/buy/received')
		->with('orderLists',$orderList)
		->with('orderDetail',$orderDetail)
		->with('orderStatus','received');
	}

	public function getRejected($order_id){
		$orderList = $this->memberProvider->orderList("Rejected");
		$orderDetail = $this->memberProvider->orderDetail($order_id);

		return $this->tempCategory('/member/buy/rejected')
		->with('orderLists',$orderList)
		->with('orderDetail',$orderDetail)
		->with('orderStatus','rejected');
	}

	public function getPaymentConfirmation($status_id=null){
		$order = $this->memberProvider->orderList("Approved");
		$order_status = $this->memberProvider->getOrderStatus($status_id);
		return $this->tempCategory('/member/buy/payment-confirmation')
		->with('orders',$order)
		->with('order_status',$order_status);
	}

	public function postPaymentConfirmation(){
		$status = $this->memberProvider->uploadPaymentSlip(Input::all());
		return Redirect::back()
		->with('status',$status);
	}

	public function postReceived(){
		$status = $this->memberProvider->orderReceived(Input::all());
		return Redirect::back()
		->with('status',$status);
	}



}
