<?php

class ImageController extends BaseController {

	public function getUploadForm(){
		return View::make('image/upload-form');
	}

	public function postUpload(){
		$file = Input::file('image');
		$input = array('image' => $file);
		$rules = array(
			'image' => 'image'
			);
		$validator = Validator::make($input, $rules);
		if ( $validator->fails() )
		{
			return Response::json(array('success' => false, 'errors' => $validator->getMessageBag()->toArray()));
		}
		else {

			$destinationPath = 'uploads/';
			$filename = Auth::user()->id.'-'.time().'-'.$file->getClientOriginalName();
			if(Input::file('image')->move($destinationPath, $filename)){
				$filenames = array();
				if (Session::has('images')){
					$filenames = Session::get('images');
				}
				$filenames[] = $filename;
				Session::put('images', $filenames);
			}

			//get all image in the folder
			return Response::json(array('success'=>true, 'file'=>Session::get('images'))); 
			//return Response::json(['success' => true, 'file' => asset($destinationPath.$filename)]);
		}
	}

	public function postRemoveImage(){
		try {
			$file = Input::get('file');
			unlink('uploads/'.$file);
			//search the key in the session
			$filenames = Session::get('images');
			$arr = array_diff($filenames, array($file));

			//put back to the session
			Session::put('images',$arr);
			//session deleted image
			Session::push('deleted_images',$file);

			return Response::json(array('success'=>true, 'file'=>Session::get('images'))); 
		} catch (Exception $e) {
			return $e;
		}
		
	}

}