<?php

class HomeController extends BaseController {

	protected $adminProvider;
	protected $memberProvider;
	protected $categoryProvider;
	protected $productProvider;
	protected $homeProvider;
	protected $storeProvider;
	protected $adsProvider;
	protected $socialProvider;

	public function __construct(){
		$this->adminProvider = App::make('AdminProvider');
		$this->memberProvider = App::make('MemberProvider');
		$this->categoryProvider = App::make('CategoryProvider');
		$this->productProvider = App::make('ProductProvider');
		$this->homeProvider = App::make('HomeProvider');
		$this->storeProvider = App::make('StoreProvider');
		$this->adsProvider = App::make('AdsProvider');
		$this->socialProvider = App::make('SocialProvider');
	}

	public function getPageNotFound(){
		return View::make('/404');
	}

	public function getFeedback(){
		return View::make('/feedback');
	}

	public function postFeedback(){
		$status = $this->homeProvider->feedback(Input::all());
		return Redirect::back()		
		->with('status',$status)
		->withInput();
	}

	public function getSearch(){
		$product = $this->homeProvider->search(Input::all());
		return $this->tempCategory('/search')		
		->with('products',$product);
	}

	public function postSearch(){
		$product = $this->homeProvider->searchPrice(Input::all());
		return $this->tempCategory('/search')		
		->with('products',$product);
	}

	public function postAdminlogin(){
		$status = $this->adminProvider->login(Input::all());
		if($status){
			return Redirect::to('/admin/main');
		}
		return Redirect::to('/admin')
		->with('status',$status);
	}

	public function postMemberlogin(){
		$status = $this->memberProvider->login(Input::all());
		if($status){
			if ($redirect = Session::get('redirect')) {
				Session::forget('redirect');
				return Redirect::to($redirect);
			}
			return Redirect::to('/member/');
		}
		return Redirect::to('/login')
		->with('statusMemberLogin',$status)
		->withInput();
	}

	public function getFbLogin(){
		$status = $this->socialProvider->loginWithFacebook();
		if($status === true)
			return Redirect::to('/member/');
		return $status;		
	}

	public function getLogout(){
		$this->productProvider->resetImageSession();
		Auth::logout();
		Session::flush();
		return Redirect::to('/');
	}

	public function getIndex(){
		$bannerB1 = $this->adsProvider->getAds('bannerB1');
		$bannerB2 = $this->adsProvider->getAds('bannerB2');
		$specialA = $this->adsProvider->getAds('specialA');

		$premium = $this->productProvider->premiumProductIndex();
		$featured = $this->productProvider->featuredProductIndex();
		$best_seller = $this->productProvider->bestSellerProductIndex();
		$new = $this->productProvider->newProductIndex();

		return $this->tempCategory('/index')
		->with('premiums',$premium)
		->with('featureds',$featured)
		->with('best_sellers',$best_seller)
		->with('news',$new)
		->with('bannerB1s',$bannerB1)
		->with('bannerB2s',$bannerB2)
		->with('specialAs',$specialA);
	}

	public function getProduct($product_id){
		$specialA = $this->adsProvider->getAds('specialA');

		$store_id = Product::find($product_id)->profile_id;
		$product = $this->productProvider->getProduct($product_id);
		$featured = $this->productProvider->featuredProductStore($store_id);
		$best = $this->productProvider->bestProductStore($store_id);
		
		// session url
		$this->homeProvider->storeUrl();

		return $this->tempCategory('/product')
		->with('product',$product)
		->with('featureds',$featured)
		->with('bests',$best)
		->with('specialAs',$specialA);
	}

	public function postBuy(){
		if(is_null(Auth::user())){
			return Redirect::to('/login');
		}
		$status = $this->homeProvider->buy(Input::all());
		return Redirect::back()
		->with('statusCart',$status);
	}

	public function getLogin(){
		return View::make('/login');
	}

	public function getForgot($type){
		return View::make('/forgot');
	}

	public function postForgot(){
		$status = $this->homeProvider->forgot(Input::all());
		return Redirect::back()
		->with('status',$status);
	}

	public function getRegister(){
		return View::make('/register');
	}

	public function postCheckAvailability(){
		return $this->homeProvider->checkAvailability(Input::get('username'));
	}

	public function postRegister(){
		$status = $this->homeProvider->register(Input::all());
		return Redirect::back()
		->with('status',$status);
	}

	public function getCategory($category_id){
		$category_product = $this->homeProvider->categoryProduct($category_id);
		$category_name = $this->homeProvider->categoryName($category_id);

		return $this->tempCategory('/category')
		->with('category_name',$category_name)
		->with('category_products',$category_product);
	}

	public function postCategory(){
		$category_product = $this->homeProvider->categoryProductSearchPrice(Input::all());
		$category_name = $this->homeProvider->categoryName(Input::get('category_id'));
		return $this->tempCategory('/category')
		->with('category_name',$category_name)
		->with('category_products',$category_product);
	}

	// SECTION STORE
	public function tempStore($page,$store_id){
		$store = $this->storeProvider->getStore($store_id);
		$store_category = $this->homeProvider->getStoreCategory($store_id);

		return View::make($page)
		->with('store',$store)
		->with('store_categorys',$store_category);
	}

	public function getSearchStore($store_id){
		$product = $this->homeProvider->searchStore(Input::all(),$store_id);
		return $this->tempStore('/store/search',$store_id)		
		->with('products',$product);
	}

	public function getStore($store_id){
		$featured = $this->productProvider->featuredProductStore($store_id);
		$new = $this->productProvider->newProductStore($store_id);
		$best = $this->productProvider->bestProductStore($store_id);

		return $this->tempStore('/store/index',$store_id)
		->with('featureds',$featured)
		->with('news',$new)
		->with('bests',$best);
	}

	public function getStoreCategory($store_id,$category_id){
		$product_category = $this->productProvider->getProductCategory($store_id,$category_id);
		return $this->tempStore('/store/storeCategory',$store_id)
		->with('product_categorys',$product_category);
	}

	public function getDelivery($store_id){
		return $this->tempStore('/store/delivery',$store_id);
	}

	public function getPayment($store_id){
		return $this->tempStore('/store/payment',$store_id);
	}

	public function getNews($store_id){
		return $this->tempStore('/store/news',$store_id);
	}

	public function getAboutUs($store_id){
		return $this->tempStore('/store/aboutUs',$store_id);
	}

	public function getContactUs($store_id){
		return $this->tempStore('/store/contactUs',$store_id);
	}

	public function getTnc($store_id){
		return $this->tempStore('/store/tnc',$store_id);
	}

	public function getAdvertising(){
		return $this->tempCategory('/advertising');
	}


}