<?php

class ApiController extends BaseController {

	protected $apiProvider;
	protected $memberProvider;
	protected $productProvider;
	protected $categoryProvider;

	public function __construct(){
		$this->apiProvider = App::make('ApiProvider');
		$this->memberProvider = App::make('MemberProvider');
		$this->productProvider = App::make('ProductProvider');
		$this->categoryProvider = App::make('CategoryProvider');
	}
	
	public function postLogin(){
		return $this->apiProvider->login(Input::all());
	}

	public function postUpdateProfile(){
		$status = $this->memberProvider->personalUpdate(Input::all());
		if($status===true)
			return json_encode(array('status'=>true));
		else
			return json_encode(array('status'=>false));
	}

	public function postAddProduct(){
		$status = $this->productProvider->productAdd(Input::all());
		if($status===true)
			return json_encode(array('status'=>true));
		else
			return json_encode(array('status'=>false));
	}

	public function getCategory(){
		return $this->categoryProvider->listCategory();
	}

	public function getOneCategory($category_id){
		return $this->categoryProvider->oneCategory($category_id);
	}

}
