<?php

class AdminController extends BaseController {

	protected $adminProvider;
	protected $adsProvider;

	public function __construct(AdminProvider $admin, AdsProvider $ads){
		$this->adminProvider = $admin;
		$this->adsProvider = $ads;
	}

	public function getIndex(){
		return View::make('admin/login');
	}

	public function getMain(){
		return View::make('admin/main');
	}

	public function getFeedback($feedback_id=null){
		$list_feedback = $this->adminProvider->listFeedback();
		$feedback = $this->adminProvider->feedbackDetail($feedback_id);
		return View::make('admin/feedback')
		->with('list_feedbacks',$list_feedback)
		->with('feedback',$feedback);
	}

	public function postFeedback($feedback_id){
		$status = $this->adminProvider->replyFeedback($feedback_id,Input::all());
		return Redirect::back()
		->with('status',$status);
	}

	public function getFeedbackDelete($feedback_id){
		$status = $this->adminProvider->deleteFeedback($feedback_id);
		return Redirect::back()
		->with('status',$status);
	}

	public function getMember(){
		$list_member = $this->adminProvider->listMember();
		return View::make('admin/member')
		->with('list_members',$list_member);
	}

	public function getProduct(){
		$list_product = $this->adminProvider->listProduct();
		return View::make('admin/product')
		->with('list_products',$list_product);
	}

	public function getRemoveProduct($product_id){
		$status = $this->adminProvider->removeProduct($product_id);
		return Redirect::back()
		->with('status',$status);
	}

	public function getAdvertising(){
		$list_ad = $this->adsProvider->listAdsMemberAdmin();
		return View::make('admin/advertising')
		->with('list_ads',$list_ad);
	}

	public function postAdvertising(){
		$status = $this->adsProvider->adsActivation(Input::all());
		return Redirect::back()
		->with('status',$status);
	}
	// ads deactivate
	public function getDeactivate($ads_id){
		$status = $this->adsProvider->adsDeactivation($ads_id);
		return Redirect::back()
		->with('status',$status);
	}
	// member account activate
	public function getMemberActivate($user_id){
		$status = $this->adminProvider->memberActivation($user_id);
		return Redirect::back()
		->with('status',$status);
	}
	// member account deactivate
	public function getMemberDeactivate($user_id){
		$status = $this->adminProvider->memberDeactivation($user_id);
		return Redirect::back()
		->with('status',$status);
	}

	// set premium product
	public function getPremium($product_id){
		$status = $this->adminProvider->setPremiumProduct($product_id);
		return Redirect::back()
		->with('status',$status);
	}

	// set featured product
	public function getFeatured($product_id){
		$status = $this->adminProvider->setFeaturedProduct($product_id);
		return Redirect::back()
		->with('status',$status);
	}


	
}
